/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebInspectorProxyMessages_h
#define WebInspectorProxyMessages_h

#include "ArgumentCoders.h"
#include "Arguments.h"
#include "Attachment.h"
#include "MessageEncoder.h"
#include "StringReference.h"
#include <wtf/text/WTFString.h>


namespace Messages {
namespace WebInspectorProxy {

static inline IPC::StringReference messageReceiverName()
{
    return IPC::StringReference("WebInspectorProxy");
}

class CreateInspectorPage {
public:
    typedef std::tuple<IPC::Attachment, bool, bool> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("CreateInspectorPage"); }
    static const bool isSync = false;

    CreateInspectorPage(const IPC::Attachment& connectionIdentifier, bool canAttach, bool underTest)
        : m_arguments(connectionIdentifier, canAttach, underTest)
    {
    }

    const std::tuple<const IPC::Attachment&, bool, bool>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const IPC::Attachment&, bool, bool> m_arguments;
};

class DidClose {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidClose"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class BringToFront {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("BringToFront"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class InspectedURLChanged {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("InspectedURLChanged"); }
    static const bool isSync = false;

    explicit InspectedURLChanged(const String& urlString)
        : m_arguments(urlString)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};

class Save {
public:
    typedef std::tuple<String, String, bool, bool> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("Save"); }
    static const bool isSync = false;

    Save(const String& filename, const String& content, bool base64Encoded, bool forceSaveAs)
        : m_arguments(filename, content, base64Encoded, forceSaveAs)
    {
    }

    const std::tuple<const String&, const String&, bool, bool>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&, const String&, bool, bool> m_arguments;
};

class Append {
public:
    typedef std::tuple<String, String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("Append"); }
    static const bool isSync = false;

    Append(const String& filename, const String& content)
        : m_arguments(filename, content)
    {
    }

    const std::tuple<const String&, const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&, const String&> m_arguments;
};

class AttachBottom {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AttachBottom"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class AttachRight {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AttachRight"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class Detach {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("Detach"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class AttachAvailabilityChanged {
public:
    typedef std::tuple<bool> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AttachAvailabilityChanged"); }
    static const bool isSync = false;

    explicit AttachAvailabilityChanged(bool available)
        : m_arguments(available)
    {
    }

    const std::tuple<bool>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<bool> m_arguments;
};

class SetAttachedWindowHeight {
public:
    typedef std::tuple<unsigned> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("SetAttachedWindowHeight"); }
    static const bool isSync = false;

    explicit SetAttachedWindowHeight(const unsigned& height)
        : m_arguments(height)
    {
    }

    const std::tuple<const unsigned&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const unsigned&> m_arguments;
};

class SetAttachedWindowWidth {
public:
    typedef std::tuple<unsigned> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("SetAttachedWindowWidth"); }
    static const bool isSync = false;

    explicit SetAttachedWindowWidth(const unsigned& width)
        : m_arguments(width)
    {
    }

    const std::tuple<const unsigned&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const unsigned&> m_arguments;
};

class StartWindowDrag {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("StartWindowDrag"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

#if ENABLE(INSPECTOR_SERVER)
class SendMessageToRemoteFrontend {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("SendMessageToRemoteFrontend"); }
    static const bool isSync = false;

    explicit SendMessageToRemoteFrontend(const String& message)
        : m_arguments(message)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};
#endif

} // namespace WebInspectorProxy
} // namespace Messages

#endif // WebInspectorProxyMessages_h
