/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsPrivateInitializeReadableStreamReaderCodeLength = 791;
const char* s_readableStreamInternalsPrivateInitializeReadableStreamReaderCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(stream))\n" \
    "       throw new @TypeError(\"ReadableStreamReader needs a ReadableStream\");\n" \
    "    if (@isReadableStreamLocked(stream))\n" \
    "       throw new @TypeError(\"ReadableStream is locked\");\n" \
    "    this.@readRequests = [];\n" \
    "    this.@ownerReadableStream = stream;\n" \
    "    stream.@reader = this;\n" \
    "    if (stream.@state === @streamReadable) {\n" \
    "        this.@closedPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "        return this;\n" \
    "    }\n" \
    "    if (stream.@state === @streamClosed) {\n" \
    "        this.@closedPromiseCapability = { @promise: @Promise.@resolve() };\n" \
    "        return this;\n" \
    "    }\n" \
    "    @assert(stream.@state === @streamErrored);\n" \
    "    this.@closedPromiseCapability = { @promise: @Promise.@reject(stream.@storedError) };\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsPrivateInitializeReadableStreamControllerCodeLength = 337;
const char* s_readableStreamInternalsPrivateInitializeReadableStreamControllerCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(stream))\n" \
    "        throw new @TypeError(\"ReadableStreamController needs a ReadableStream\");\n" \
    "    if (stream.@controller !== @undefined)\n" \
    "        throw new @TypeError(\"ReadableStream already has a controller\");\n" \
    "    this.@controlledReadableStream = stream;\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsTeeReadableStreamCodeLength = 1211;
const char* s_readableStreamInternalsTeeReadableStreamCode =
    "(function (stream, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    @assert(typeof(shouldClone) === \"boolean\");\n" \
    "    const reader = new @ReadableStreamReader(stream);\n" \
    "    const teeState = {\n" \
    "        closedOrErrored: false,\n" \
    "        canceled1: false,\n" \
    "        canceled2: false,\n" \
    "        reason1: @undefined,\n" \
    "        reason: @undefined,\n" \
    "    };\n" \
    "    teeState.cancelPromiseCapability = @newPromiseCapability(@InternalPromise);\n" \
    "    const pullFunction = @teeReadableStreamPullFunction(teeState, reader, shouldClone);\n" \
    "    const branch1 = new @ReadableStream({\n" \
    "        \"pull\": pullFunction,\n" \
    "        \"cancel\": @teeReadableStreamBranch1CancelFunction(teeState, stream)\n" \
    "    });\n" \
    "    const branch2 = new @ReadableStream({\n" \
    "        \"pull\": pullFunction,\n" \
    "        \"cancel\": @teeReadableStreamBranch2CancelFunction(teeState, stream)\n" \
    "    });\n" \
    "    reader.@closedPromiseCapability.@promise.@then(@undefined, function(e) {\n" \
    "        if (teeState.closedOrErrored)\n" \
    "            return;\n" \
    "        @errorReadableStream(branch1, e);\n" \
    "        @errorReadableStream(branch2, e);\n" \
    "        teeState.closedOrErrored = true;\n" \
    "    });\n" \
    "    teeState.branch1 = branch1;\n" \
    "    teeState.branch2 = branch2;\n" \
    "    return [branch1, branch2];\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamPullFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsTeeReadableStreamPullFunctionCodeLength = 854;
const char* s_readableStreamInternalsTeeReadableStreamPullFunctionCode =
    "(function (teeState, reader, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return function() {\n" \
    "        @Promise.prototype.@then.@call(@readFromReadableStreamReader(reader), function(result) {\n" \
    "            @assert(@isObject(result));\n" \
    "            @assert(typeof result.done === \"boolean\");\n" \
    "            if (result.done && !teeState.closedOrErrored) {\n" \
    "                @closeReadableStream(teeState.branch1);\n" \
    "                @closeReadableStream(teeState.branch2);\n" \
    "                teeState.closedOrErrored = true;\n" \
    "            }\n" \
    "            if (teeState.closedOrErrored)\n" \
    "                return;\n" \
    "            if (!teeState.canceled1) {\n" \
    "                @enqueueInReadableStream(teeState.branch1, result.value);\n" \
    "            }\n" \
    "            if (!teeState.canceled2) {\n" \
    "                @enqueueInReadableStream(teeState.branch2, result.value);\n" \
    "            }\n" \
    "        });\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCodeLength = 455;
const char* s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return function(r) {\n" \
    "        teeState.canceled1 = true;\n" \
    "        teeState.reason1 = r;\n" \
    "        if (teeState.canceled2) {\n" \
    "            @cancelReadableStream(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.@resolve,\n" \
    "                teeState.cancelPromiseCapability.@reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.@promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCodeLength = 455;
const char* s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return function(r) {\n" \
    "        teeState.canceled2 = true;\n" \
    "        teeState.reason2 = r;\n" \
    "        if (teeState.canceled1) {\n" \
    "            @cancelReadableStream(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.@resolve,\n" \
    "                teeState.cancelPromiseCapability.@reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.@promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsIsReadableStreamCodeLength = 102;
const char* s_readableStreamInternalsIsReadableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @isObject(stream) && !!stream.@underlyingSource;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsIsReadableStreamReaderCodeLength = 118;
const char* s_readableStreamInternalsIsReadableStreamReaderCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @isObject(reader) && reader.@ownerReadableStream !== @undefined;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsIsReadableStreamControllerCodeLength = 122;
const char* s_readableStreamInternalsIsReadableStreamControllerCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @isObject(controller) && !!controller.@controlledReadableStream;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsErrorReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsErrorReadableStreamCodeLength = 552;
const char* s_readableStreamInternalsErrorReadableStreamCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(stream.@state === @streamReadable);\n" \
    "    stream.@queue = @newQueue();\n" \
    "    stream.@storedError = error;\n" \
    "    stream.@state = @streamErrored;\n" \
    "    if (!stream.@reader)\n" \
    "        return;\n" \
    "    const reader = stream.@reader;\n" \
    "    const requests = reader.@readRequests;\n" \
    "    for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "        requests[index].@reject.@call(@undefined, error);\n" \
    "    reader.@readRequests = [];\n" \
    "    reader.@closedPromiseCapability.@reject.@call(@undefined, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsRequestReadableStreamPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsRequestReadableStreamPullCodeLength = 876;
const char* s_readableStreamInternalsRequestReadableStreamPullCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (stream.@state === @streamClosed || stream.@state === @streamErrored)\n" \
    "        return;\n" \
    "    if (stream.@closeRequested)\n" \
    "        return;\n" \
    "    if (!stream.@started)\n" \
    "        return;\n" \
    "    if ((!@isReadableStreamLocked(stream) || !stream.@reader.@readRequests.length) && @getReadableStreamDesiredSize(stream) <= 0)\n" \
    "        return;\n" \
    " \n" \
    "    if (stream.@pulling) {\n" \
    "        stream.@pullAgain = true;\n" \
    "        return;\n" \
    "    }\n" \
    "    stream.@pulling = true;\n" \
    "    @promiseInvokeOrNoop(stream.@underlyingSource, \"pull\", [stream.@controller]).@then(function() {\n" \
    "        stream.@pulling = false;\n" \
    "        if (stream.@pullAgain) {\n" \
    "            stream.@pullAgain = false;\n" \
    "            @requestReadableStreamPull(stream);\n" \
    "        }\n" \
    "    }, function(error) {\n" \
    "        if (stream.@state === @streamReadable)\n" \
    "            @errorReadableStream(stream, error);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsIsReadableStreamLockedCodeLength = 110;
const char* s_readableStreamInternalsIsReadableStreamLockedCode =
    "(function (stream)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return !!stream.@reader;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsGetReadableStreamDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsGetReadableStreamDesiredSizeCodeLength = 104;
const char* s_readableStreamInternalsGetReadableStreamDesiredSizeCode =
    "(function (stream)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "   return stream.@strategy.highWaterMark - stream.@queue.size;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsCancelReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsCancelReadableStreamCodeLength = 429;
const char* s_readableStreamInternalsCancelReadableStreamCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    stream.@disturbed = true;\n" \
    "    if (stream.@state === @streamClosed)\n" \
    "        return @Promise.@resolve();\n" \
    "    if (stream.@state === @streamErrored)\n" \
    "        return @Promise.@reject(stream.@storedError);\n" \
    "    stream.@queue = @newQueue();\n" \
    "    @finishClosingReadableStream(stream);\n" \
    "    return @promiseInvokeOrNoop(stream.@underlyingSource, \"cancel\", [reason]).@then(function() { });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsFinishClosingReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsFinishClosingReadableStreamCodeLength = 481;
const char* s_readableStreamInternalsFinishClosingReadableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(stream.@state ===  @streamReadable);\n" \
    "    stream.@state = @streamClosed;\n" \
    "    const reader = stream.@reader;\n" \
    "    if (!reader)\n" \
    "        return;\n" \
    "    const requests = reader.@readRequests;\n" \
    "    for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "        requests[index].@resolve.@call(@undefined, {value:@undefined, done: true});\n" \
    "    reader.@readRequests = [];\n" \
    "    reader.@closedPromiseCapability.@resolve.@call();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsCloseReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsCloseReadableStreamCodeLength = 305;
const char* s_readableStreamInternalsCloseReadableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(!stream.@closeRequested);\n" \
    "    @assert(stream.@state !== @streamErrored);\n" \
    "    if (stream.@state === @streamClosed)\n" \
    "        return; \n" \
    "    stream.@closeRequested = true;\n" \
    "    if (!stream.@queue.content.length)\n" \
    "        @finishClosingReadableStream(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsEnqueueInReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsEnqueueInReadableStreamCodeLength = 938;
const char* s_readableStreamInternalsEnqueueInReadableStreamCode =
    "(function (stream, chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(!stream.@closeRequested);\n" \
    "    @assert(stream.@state !== @streamErrored);\n" \
    "    if (stream.@state === @streamClosed)\n" \
    "        return;\n" \
    "    if (@isReadableStreamLocked(stream) && stream.@reader.@readRequests.length) {\n" \
    "        stream.@reader.@readRequests.@shift().@resolve.@call(@undefined, {value: chunk, done: false});\n" \
    "        @requestReadableStreamPull(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "    try {\n" \
    "        let size = 1;\n" \
    "        if (stream.@strategy.size) {\n" \
    "            size = @Number(stream.@strategy.size(chunk));\n" \
    "            if (!@isFinite(size) || size < 0)\n" \
    "                throw new @RangeError(\"Chunk size is not valid\");\n" \
    "        }\n" \
    "        @enqueueValueWithSize(stream.@queue, chunk, size);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        if (stream.@state === @streamReadable)\n" \
    "            @errorReadableStream(stream, error);\n" \
    "        throw error;\n" \
    "    }\n" \
    "    @requestReadableStreamPull(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadFromReadableStreamReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsReadFromReadableStreamReaderCodeLength = 946;
const char* s_readableStreamInternalsReadFromReadableStreamReaderCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const stream = reader.@ownerReadableStream;\n" \
    "    @assert(!!stream);\n" \
    "    stream.@disturbed = true;\n" \
    "    if (stream.@state === @streamClosed)\n" \
    "        return @Promise.@resolve({value: @undefined, done: true});\n" \
    "    if (stream.@state === @streamErrored)\n" \
    "        return @Promise.@reject(stream.@storedError);\n" \
    "    @assert(stream.@state === @streamReadable);\n" \
    "    if (stream.@queue.content.length) {\n" \
    "        const chunk = @dequeueValue(stream.@queue);\n" \
    "        if (stream.@closeRequested && stream.@queue.content.length === 0)\n" \
    "            @finishClosingReadableStream(stream);\n" \
    "        else\n" \
    "            @requestReadableStreamPull(stream);\n" \
    "        return @Promise.@resolve({value: chunk, done: false});\n" \
    "    }\n" \
    "    const readPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    reader.@readRequests.@push(readPromiseCapability);\n" \
    "    @requestReadableStreamPull(stream);\n" \
    "    return readPromiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength = 112;
const char* s_readableStreamInternalsIsReadableStreamDisturbedCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return stream.@disturbed;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
