/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerNavigator.h"

#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWorkerNavigatorAppName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorAppVersion(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorPlatform(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorUserAgent(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorOnLine(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerNavigatorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWorkerNavigatorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWorkerNavigatorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWorkerNavigatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSWorkerNavigatorPrototype>(vm.heap)) JSWorkerNavigatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWorkerNavigatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWorkerNavigatorPrototypeTableValues[] =
{
    { "appName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "appVersion", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppVersion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "platform", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorPlatform), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "userAgent", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorUserAgent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onLine", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorOnLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWorkerNavigatorPrototype::s_info = { "WorkerNavigatorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerNavigatorPrototype) };

void JSWorkerNavigatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWorkerNavigatorPrototypeTableValues, *this);
}

const ClassInfo JSWorkerNavigator::s_info = { "WorkerNavigator", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerNavigator) };

JSWorkerNavigator::JSWorkerNavigator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WorkerNavigator>&& impl)
    : JSDOMWrapper<WorkerNavigator>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWorkerNavigator::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWorkerNavigatorPrototype::create(vm, globalObject, JSWorkerNavigatorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWorkerNavigator::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorkerNavigator>(vm, globalObject);
}

void JSWorkerNavigator::destroy(JSC::JSCell* cell)
{
    JSWorkerNavigator* thisObject = static_cast<JSWorkerNavigator*>(cell);
    thisObject->JSWorkerNavigator::~JSWorkerNavigator();
}

EncodedJSValue jsWorkerNavigatorAppName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerNavigator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerNavigator", "appName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.appName());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerNavigatorAppVersion(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerNavigator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerNavigator", "appVersion");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.appVersion());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerNavigatorPlatform(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerNavigator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerNavigator", "platform");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.platform());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerNavigatorUserAgent(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerNavigator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerNavigator", "userAgent");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.userAgent());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerNavigatorOnLine(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerNavigator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerNavigator", "onLine");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.onLine());
    return JSValue::encode(result);
}


void setJSWorkerNavigatorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWorkerNavigatorPrototype* domObject = jsDynamicCast<JSWorkerNavigatorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSWorkerNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.slot()->asCell());
    WorkerNavigator* root = &jsWorkerNavigator->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSWorkerNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWorkerNavigator->wrapped(), jsWorkerNavigator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WorkerNavigator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WorkerNavigatorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WorkerNavigator* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWorkerNavigator>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WorkerNavigator* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWorkerNavigator>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WorkerNavigator@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15WorkerNavigatorE[2];
#if COMPILER(CLANG)
    // If this fails WorkerNavigator does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WorkerNavigator), WorkerNavigator_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WorkerNavigator has subclasses. If WorkerNavigator has subclasses that get passed
    // to toJS() we currently require WorkerNavigator you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWorkerNavigator>(globalObject, impl);
}

WorkerNavigator* JSWorkerNavigator::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerNavigator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
