/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitNamedFlow.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "JSNodeCustom.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegionsByContent(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegions(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetContent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWebKitNamedFlowName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebKitNamedFlowOverset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebKitNamedFlowFirstEmptyRegionIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitNamedFlowConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebKitNamedFlowPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebKitNamedFlowPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitNamedFlowPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitNamedFlowPrototype>(vm.heap)) JSWebKitNamedFlowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitNamedFlowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebKitNamedFlowPrototypeTableValues[] =
{
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "overset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowOverset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstEmptyRegionIndex", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowFirstEmptyRegionIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getRegionsByContent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetRegionsByContent), (intptr_t) (1) } },
    { "getRegions", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetRegions), (intptr_t) (0) } },
    { "getContent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetContent), (intptr_t) (0) } },
};

const ClassInfo JSWebKitNamedFlowPrototype::s_info = { "WebKitNamedFlowPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitNamedFlowPrototype) };

void JSWebKitNamedFlowPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitNamedFlowPrototypeTableValues, *this);
}

const ClassInfo JSWebKitNamedFlow::s_info = { "WebKitNamedFlow", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitNamedFlow) };

JSWebKitNamedFlow::JSWebKitNamedFlow(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitNamedFlow>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebKitNamedFlow::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebKitNamedFlowPrototype::create(vm, globalObject, JSWebKitNamedFlowPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSWebKitNamedFlow::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitNamedFlow>(vm, globalObject);
}

EncodedJSValue jsWebKitNamedFlowName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitNamedFlow*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitNamedFlow", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitNamedFlowOverset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitNamedFlow*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitNamedFlow", "overset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.overset());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitNamedFlowFirstEmptyRegionIndex(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitNamedFlow*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitNamedFlow", "firstEmptyRegionIndex");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.firstEmptyRegionIndex());
    return JSValue::encode(result);
}


void setJSWebKitNamedFlowConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebKitNamedFlowPrototype* domObject = jsDynamicCast<JSWebKitNamedFlowPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegionsByContent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitNamedFlow*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitNamedFlow", "getRegionsByContent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitNamedFlow::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Node* contentNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getRegionsByContent(contentNode)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegions(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitNamedFlow*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitNamedFlow", "getRegions");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitNamedFlow::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getRegions()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetContent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitNamedFlow*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitNamedFlow", "getContent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitNamedFlow::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getContent()));
    return JSValue::encode(result);
}

void JSWebKitNamedFlow::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWebKitNamedFlow*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSWebKitNamedFlowOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebKitNamedFlow = jsCast<JSWebKitNamedFlow*>(handle.slot()->asCell());
    if (jsWebKitNamedFlow->wrapped().isFiringEventListeners())
        return true;
    void* root = WebCore::root(jsWebKitNamedFlow->wrapped().ownerNode());
    return visitor.containsOpaqueRoot(root);
}

void JSWebKitNamedFlowOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitNamedFlow = jsCast<JSWebKitNamedFlow*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebKitNamedFlow->wrapped(), jsWebKitNamedFlow);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitNamedFlow@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WebKitNamedFlowE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitNamedFlow* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebKitNamedFlow>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitNamedFlow* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebKitNamedFlow>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebKitNamedFlow@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15WebKitNamedFlowE[2];
#if COMPILER(CLANG)
    // If this fails WebKitNamedFlow does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebKitNamedFlow), WebKitNamedFlow_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebKitNamedFlow has subclasses. If WebKitNamedFlow has subclasses that get passed
    // to toJS() we currently require WebKitNamedFlow you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebKitNamedFlow>(globalObject, impl);
}

WebKitNamedFlow* JSWebKitNamedFlow::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitNamedFlow*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
