/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTexturePVRTC.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSWebGLCompressedTexturePVRTCPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLCompressedTexturePVRTCPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTexturePVRTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTexturePVRTCPrototype>(vm.heap)) JSWebGLCompressedTexturePVRTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTexturePVRTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTexturePVRTCPrototypeTableValues[] =
{
    { "COMPRESSED_RGB_PVRTC_4BPPV1_IMG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C00) } },
    { "COMPRESSED_RGB_PVRTC_2BPPV1_IMG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C01) } },
    { "COMPRESSED_RGBA_PVRTC_4BPPV1_IMG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C02) } },
    { "COMPRESSED_RGBA_PVRTC_2BPPV1_IMG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C03) } },
};

const ClassInfo JSWebGLCompressedTexturePVRTCPrototype::s_info = { "WebGLCompressedTexturePVRTCPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLCompressedTexturePVRTCPrototype) };

void JSWebGLCompressedTexturePVRTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTexturePVRTCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTexturePVRTC::s_info = { "WebGLCompressedTexturePVRTC", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLCompressedTexturePVRTC) };

JSWebGLCompressedTexturePVRTC::JSWebGLCompressedTexturePVRTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTexturePVRTC>&& impl)
    : JSDOMWrapper<WebGLCompressedTexturePVRTC>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLCompressedTexturePVRTC::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLCompressedTexturePVRTCPrototype::create(vm, globalObject, JSWebGLCompressedTexturePVRTCPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLCompressedTexturePVRTC::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTexturePVRTC>(vm, globalObject);
}

void JSWebGLCompressedTexturePVRTC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTexturePVRTC* thisObject = static_cast<JSWebGLCompressedTexturePVRTC*>(cell);
    thisObject->JSWebGLCompressedTexturePVRTC::~JSWebGLCompressedTexturePVRTC();
}

bool JSWebGLCompressedTexturePVRTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLCompressedTexturePVRTC = jsCast<JSWebGLCompressedTexturePVRTC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTexturePVRTC->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTexturePVRTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTexturePVRTC = jsCast<JSWebGLCompressedTexturePVRTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTexturePVRTC->wrapped(), jsWebGLCompressedTexturePVRTC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTexturePVRTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27WebGLCompressedTexturePVRTCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLCompressedTexturePVRTC* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLCompressedTexturePVRTC>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLCompressedTexturePVRTC* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLCompressedTexturePVRTC>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLCompressedTexturePVRTC@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27WebGLCompressedTexturePVRTCE[2];
#if COMPILER(CLANG)
    // If this fails WebGLCompressedTexturePVRTC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLCompressedTexturePVRTC), WebGLCompressedTexturePVRTC_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTexturePVRTC has subclasses. If WebGLCompressedTexturePVRTC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTexturePVRTC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLCompressedTexturePVRTC>(globalObject, impl);
}

WebGLCompressedTexturePVRTC* JSWebGLCompressedTexturePVRTC::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTexturePVRTC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
