/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVideoTrack.h"

#include "Element.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNodeCustom.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsVideoTrackId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoTrackKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVideoTrackKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVideoTrackLabel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoTrackLanguage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVideoTrackLanguage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVideoTrackSelected(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVideoTrackSelected(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVideoTrackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVideoTrackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVideoTrackPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSVideoTrackPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackPrototype>(vm.heap)) JSVideoTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSVideoTrack> JSVideoTrackConstructor;

template<> JSValue JSVideoTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVideoTrack::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("VideoTrack"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSVideoTrackConstructor::s_info = { "VideoTrack", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVideoTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVideoTrackPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackConstructor) } },
    { "id", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kind", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackKind) } },
    { "label", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "language", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackLanguage) } },
    { "selected", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackSelected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackSelected) } },
};

const ClassInfo JSVideoTrackPrototype::s_info = { "VideoTrackPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVideoTrackPrototype) };

void JSVideoTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoTrackPrototypeTableValues, *this);
}

const ClassInfo JSVideoTrack::s_info = { "VideoTrack", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVideoTrack) };

JSVideoTrack::JSVideoTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoTrack>&& impl)
    : JSDOMWrapper<VideoTrack>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSVideoTrack::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSVideoTrackPrototype::create(vm, globalObject, JSVideoTrackPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSVideoTrack::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSVideoTrack>(vm, globalObject);
}

void JSVideoTrack::destroy(JSC::JSCell* cell)
{
    JSVideoTrack* thisObject = static_cast<JSVideoTrack*>(cell);
    thisObject->JSVideoTrack::~JSVideoTrack();
}

EncodedJSValue jsVideoTrackId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoTrack", "id");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.id());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoTrackKind(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoTrack", "kind");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.kind());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoTrackLabel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoTrack", "label");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.label());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoTrackLanguage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoTrack", "language");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.language());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoTrackSelected(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoTrack", "selected");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.selected());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoTrackConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSVideoTrackPrototype* domObject = jsDynamicCast<JSVideoTrackPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSVideoTrack::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSVideoTrackConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSVideoTrackPrototype* domObject = jsDynamicCast<JSVideoTrackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSVideoTrackKind(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVideoTrack* castedThis = jsDynamicCast<JSVideoTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VideoTrack", "kind");
        return;
    }
    castedThis->setKind(*state, value);
}


void setJSVideoTrackLanguage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVideoTrack* castedThis = jsDynamicCast<JSVideoTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VideoTrack", "language");
        return;
    }
    castedThis->setLanguage(*state, value);
}


void setJSVideoTrackSelected(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVideoTrack* castedThis = jsDynamicCast<JSVideoTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VideoTrack", "selected");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSelected(nativeValue);
}


JSValue JSVideoTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoTrack::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSVideoTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSVideoTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsVideoTrack = jsCast<JSVideoTrack*>(handle.slot()->asCell());
    Element* element = WTF::getPtr(jsVideoTrack->wrapped().element());
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSVideoTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoTrack = jsCast<JSVideoTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoTrack->wrapped(), jsVideoTrack);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10VideoTrackE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, VideoTrack* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSVideoTrack>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, VideoTrack* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSVideoTrack>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7VideoTrack@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10VideoTrackE[2];
#if COMPILER(CLANG)
    // If this fails VideoTrack does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(VideoTrack), VideoTrack_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // VideoTrack has subclasses. If VideoTrack has subclasses that get passed
    // to toJS() we currently require VideoTrack you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSVideoTrack>(globalObject, impl);
}

VideoTrack* JSVideoTrack::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoTrack*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
