/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTransitionEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsTransitionEventPropertyName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTransitionEventElapsedTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTransitionEventPseudoElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTransitionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTransitionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTransitionEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTransitionEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTransitionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSTransitionEventPrototype>(vm.heap)) JSTransitionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTransitionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSTransitionEvent> JSTransitionEventConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSTransitionEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSTransitionEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    TransitionEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillTransitionEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<TransitionEvent> event = TransitionEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillTransitionEventInit(TransitionEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("propertyName", eventInit.propertyName))
        return false;
    if (!dictionary.tryGetProperty("elapsedTime", eventInit.elapsedTime))
        return false;
    if (!dictionary.tryGetProperty("pseudoElement", eventInit.pseudoElement))
        return false;
    return true;
}

template<> JSValue JSTransitionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSTransitionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTransitionEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TransitionEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTransitionEventConstructor::s_info = { "TransitionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTransitionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTransitionEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransitionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTransitionEventConstructor) } },
    { "propertyName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransitionEventPropertyName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "elapsedTime", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransitionEventElapsedTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pseudoElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransitionEventPseudoElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSTransitionEventPrototype::s_info = { "TransitionEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTransitionEventPrototype) };

void JSTransitionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTransitionEventPrototypeTableValues, *this);
}

const ClassInfo JSTransitionEvent::s_info = { "TransitionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTransitionEvent) };

JSTransitionEvent::JSTransitionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TransitionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTransitionEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTransitionEventPrototype::create(vm, globalObject, JSTransitionEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSTransitionEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTransitionEvent>(vm, globalObject);
}

EncodedJSValue jsTransitionEventPropertyName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTransitionEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TransitionEvent", "propertyName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.propertyName());
    return JSValue::encode(result);
}


EncodedJSValue jsTransitionEventElapsedTime(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTransitionEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TransitionEvent", "elapsedTime");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.elapsedTime());
    return JSValue::encode(result);
}


EncodedJSValue jsTransitionEventPseudoElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTransitionEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TransitionEvent", "pseudoElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pseudoElement());
    return JSValue::encode(result);
}


EncodedJSValue jsTransitionEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTransitionEventPrototype* domObject = jsDynamicCast<JSTransitionEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTransitionEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTransitionEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTransitionEventPrototype* domObject = jsDynamicCast<JSTransitionEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSTransitionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTransitionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
