/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSTimeRanges.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionEnd(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTimeRangesLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTimeRangesConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTimeRangesConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTimeRangesPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTimeRangesPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTimeRangesPrototype* ptr = new (NotNull, JSC::allocateCell<JSTimeRangesPrototype>(vm.heap)) JSTimeRangesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTimeRangesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTimeRanges> JSTimeRangesConstructor;

template<> JSValue JSTimeRangesConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTimeRangesConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTimeRanges::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TimeRanges"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTimeRangesConstructor::s_info = { "TimeRanges", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTimeRangesConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTimeRangesPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimeRangesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTimeRangesConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimeRangesLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "start", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTimeRangesPrototypeFunctionStart), (intptr_t) (1) } },
    { "end", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTimeRangesPrototypeFunctionEnd), (intptr_t) (1) } },
};

const ClassInfo JSTimeRangesPrototype::s_info = { "TimeRangesPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTimeRangesPrototype) };

void JSTimeRangesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTimeRangesPrototypeTableValues, *this);
}

const ClassInfo JSTimeRanges::s_info = { "TimeRanges", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTimeRanges) };

JSTimeRanges::JSTimeRanges(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TimeRanges>&& impl)
    : JSDOMWrapper<TimeRanges>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTimeRanges::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTimeRangesPrototype::create(vm, globalObject, JSTimeRangesPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTimeRanges::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTimeRanges>(vm, globalObject);
}

void JSTimeRanges::destroy(JSC::JSCell* cell)
{
    JSTimeRanges* thisObject = static_cast<JSTimeRanges*>(cell);
    thisObject->JSTimeRanges::~JSTimeRanges();
}

EncodedJSValue jsTimeRangesLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTimeRanges*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TimeRanges", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsTimeRangesConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTimeRangesPrototype* domObject = jsDynamicCast<JSTimeRangesPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTimeRanges::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTimeRangesConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTimeRangesPrototype* domObject = jsDynamicCast<JSTimeRangesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSTimeRanges::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTimeRangesConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTimeRanges*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TimeRanges", "start");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTimeRanges::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.start(index, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionEnd(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTimeRanges*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TimeRanges", "end");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTimeRanges::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.end(index, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSTimeRangesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTimeRangesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTimeRanges = jsCast<JSTimeRanges*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTimeRanges->wrapped(), jsTimeRanges);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TimeRanges* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTimeRanges>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TimeRanges* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTimeRanges>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TimeRanges.
    COMPILE_ASSERT(!__is_polymorphic(TimeRanges), TimeRanges_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTimeRanges>(globalObject, impl);
}

TimeRanges* JSTimeRanges::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTimeRanges*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
