/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGViewSpec.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGElement.h"
#include "JSSVGTransformList.h"
#include "SVGElement.h"
#include "SVGTransformList.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGViewSpecTransform(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewBoxString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecPreserveAspectRatioString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecTransformString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewTargetString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecZoomAndPan(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGViewSpecZoomAndPan(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGViewSpecViewBox(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecPreserveAspectRatio(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGViewSpecConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGViewSpecPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGViewSpecPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGViewSpecPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGViewSpecPrototype>(vm.heap)) JSSVGViewSpecPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGViewSpecPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGViewSpec> JSSVGViewSpecConstructor;

template<> JSValue JSSVGViewSpecConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGViewSpecConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGViewSpec::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGViewSpec"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGViewSpecConstructor::s_info = { "SVGViewSpec", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGViewSpecConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGViewSpecPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGViewSpecConstructor) } },
    { "transform", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransform), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewTarget", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewBoxString", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBoxString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preserveAspectRatioString", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatioString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transformString", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransformString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewTargetString", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTargetString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "zoomAndPan", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecZoomAndPan), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGViewSpecZoomAndPan) } },
    { "viewBox", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBox), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preserveAspectRatio", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGViewSpecPrototype::s_info = { "SVGViewSpecPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGViewSpecPrototype) };

void JSSVGViewSpecPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGViewSpecPrototypeTableValues, *this);
}

const ClassInfo JSSVGViewSpec::s_info = { "SVGViewSpec", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGViewSpec) };

JSSVGViewSpec::JSSVGViewSpec(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGViewSpec>&& impl)
    : JSDOMWrapper<SVGViewSpec>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGViewSpec::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGViewSpecPrototype::create(vm, globalObject, JSSVGViewSpecPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGViewSpec::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGViewSpec>(vm, globalObject);
}

void JSSVGViewSpec::destroy(JSC::JSCell* cell)
{
    JSSVGViewSpec* thisObject = static_cast<JSSVGViewSpec*>(cell);
    thisObject->JSSVGViewSpec::~JSSVGViewSpec();
}

EncodedJSValue jsSVGViewSpecTransform(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "transform");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(static_cast<SVGTransformListPropertyTearOff*>(impl.transform().get())));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecViewTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "viewTarget");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(static_cast<SVGElement*>(impl.viewTarget())));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecViewBoxString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "viewBoxString");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.viewBoxString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecPreserveAspectRatioString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "preserveAspectRatioString");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.preserveAspectRatioString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecTransformString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "transformString");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.transformString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecViewTargetString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "viewTargetString");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.viewTargetString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecZoomAndPan(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "zoomAndPan");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.zoomAndPan());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecViewBox(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "viewBox");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedRect> obj = impl.viewBoxAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecPreserveAspectRatio(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGViewSpec*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGViewSpec", "preserveAspectRatio");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl.preserveAspectRatioAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGViewSpecConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGViewSpecPrototype* domObject = jsDynamicCast<JSSVGViewSpecPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGViewSpec::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGViewSpecConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGViewSpecPrototype* domObject = jsDynamicCast<JSSVGViewSpecPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGViewSpecZoomAndPan(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGViewSpec* castedThis = jsDynamicCast<JSSVGViewSpec*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGViewSpec", "zoomAndPan");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    uint16_t nativeValue = toUInt16(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setZoomAndPan(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSSVGViewSpec::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGViewSpecConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGViewSpecOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGViewSpecOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGViewSpec = jsCast<JSSVGViewSpec*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGViewSpec->wrapped(), jsSVGViewSpec);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGViewSpec@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11SVGViewSpecE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGViewSpec* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGViewSpec>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGViewSpec* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGViewSpec>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SVGViewSpec@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11SVGViewSpecE[2];
#if COMPILER(CLANG)
    // If this fails SVGViewSpec does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SVGViewSpec), SVGViewSpec_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SVGViewSpec has subclasses. If SVGViewSpec has subclasses that get passed
    // to toJS() we currently require SVGViewSpec you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSSVGViewSpec>(globalObject, impl);
}

SVGViewSpec* JSSVGViewSpec::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGViewSpec*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
