/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPointList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGPoint.h"
#include "SVGPoint.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInitialize(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionGetItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInsertItemBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionReplaceItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionRemoveItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionAppendItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGPointListNumberOfItems(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPointListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPointListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPointListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGPointListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPointListPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPointListPrototype>(vm.heap)) JSSVGPointListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPointListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGPointList> JSSVGPointListConstructor;

template<> JSValue JSSVGPointListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPointListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPointList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGPointList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGPointListConstructor::s_info = { "SVGPointList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPointListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPointListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPointListConstructor) } },
    { "numberOfItems", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointListNumberOfItems), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clear", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionClear), (intptr_t) (0) } },
    { "initialize", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionInitialize), (intptr_t) (1) } },
    { "getItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionGetItem), (intptr_t) (1) } },
    { "insertItemBefore", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionInsertItemBefore), (intptr_t) (2) } },
    { "replaceItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionReplaceItem), (intptr_t) (2) } },
    { "removeItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionRemoveItem), (intptr_t) (1) } },
    { "appendItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionAppendItem), (intptr_t) (1) } },
};

const ClassInfo JSSVGPointListPrototype::s_info = { "SVGPointListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPointListPrototype) };

void JSSVGPointListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPointListPrototypeTableValues, *this);
}

const ClassInfo JSSVGPointList::s_info = { "SVGPointList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPointList) };

JSSVGPointList::JSSVGPointList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGListPropertyTearOff<SVGPointList>>&& impl)
    : JSDOMWrapper<SVGListPropertyTearOff<SVGPointList>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGPointList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGPointListPrototype::create(vm, globalObject, JSSVGPointListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGPointList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPointList>(vm, globalObject);
}

void JSSVGPointList::destroy(JSC::JSCell* cell)
{
    JSSVGPointList* thisObject = static_cast<JSSVGPointList*>(cell);
    thisObject->JSSVGPointList::~JSSVGPointList();
}

EncodedJSValue jsSVGPointListNumberOfItems(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPointList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPointList", "numberOfItems");
    }
    JSValue result =  jsNumber(castedThis->wrapped().numberOfItems());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPointListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGPointListPrototype* domObject = jsDynamicCast<JSSVGPointListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGPointList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGPointListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGPointListPrototype* domObject = jsDynamicCast<JSSVGPointListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGPointList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPointListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionClear(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "clear");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.clear(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInitialize(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "initialize");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGPoint::info()))
        return throwArgumentTypeError(*state, 0, "item", "SVGPointList", "initialize", "SVGPoint");
    SVGPropertyTearOff<SVGPoint>* item = JSSVGPoint::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.initialize(item, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionGetItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "getItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getItem(index, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInsertItemBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "insertItemBefore");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGPoint::info()))
        return throwArgumentTypeError(*state, 0, "item", "SVGPointList", "insertItemBefore", "SVGPoint");
    SVGPropertyTearOff<SVGPoint>* item = JSSVGPoint::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned index = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.insertItemBefore(item, index, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionReplaceItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "replaceItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGPoint::info()))
        return throwArgumentTypeError(*state, 0, "item", "SVGPointList", "replaceItem", "SVGPoint");
    SVGPropertyTearOff<SVGPoint>* item = JSSVGPoint::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned index = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.replaceItem(item, index, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionRemoveItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "removeItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.removeItem(index, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionAppendItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPointList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPointList", "appendItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPointList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGPoint::info()))
        return throwArgumentTypeError(*state, 0, "item", "SVGPointList", "appendItem", "SVGPoint");
    SVGPropertyTearOff<SVGPoint>* item = JSSVGPoint::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.appendItem(item, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSSVGPointListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPointListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPointList = jsCast<JSSVGPointList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGPointList->wrapped(), jsSVGPointList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGListPropertyTearOff<SVGPointList>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGPointList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGListPropertyTearOff<SVGPointList>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGPointList>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGPointList>(globalObject, impl);
}

SVGListPropertyTearOff<SVGPointList>* JSSVGPointList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPointList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
