/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG_FONTS)

#include "JSSVGFontFaceFormatElement.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGFontFaceFormatElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGFontFaceFormatElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGFontFaceFormatElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGFontFaceFormatElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGFontFaceFormatElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGFontFaceFormatElementPrototype>(vm.heap)) JSSVGFontFaceFormatElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGFontFaceFormatElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGFontFaceFormatElement> JSSVGFontFaceFormatElementConstructor;

template<> JSValue JSSVGFontFaceFormatElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGFontFaceFormatElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGFontFaceFormatElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGFontFaceFormatElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGFontFaceFormatElementConstructor::s_info = { "SVGFontFaceFormatElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFontFaceFormatElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGFontFaceFormatElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFontFaceFormatElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGFontFaceFormatElementConstructor) } },
};

const ClassInfo JSSVGFontFaceFormatElementPrototype::s_info = { "SVGFontFaceFormatElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFontFaceFormatElementPrototype) };

void JSSVGFontFaceFormatElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGFontFaceFormatElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGFontFaceFormatElement::s_info = { "SVGFontFaceFormatElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFontFaceFormatElement) };

JSSVGFontFaceFormatElement::JSSVGFontFaceFormatElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGFontFaceFormatElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGFontFaceFormatElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGFontFaceFormatElementPrototype::create(vm, globalObject, JSSVGFontFaceFormatElementPrototype::createStructure(vm, globalObject, JSSVGElement::getPrototype(vm, globalObject)));
}

JSObject* JSSVGFontFaceFormatElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFontFaceFormatElement>(vm, globalObject);
}

EncodedJSValue jsSVGFontFaceFormatElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGFontFaceFormatElementPrototype* domObject = jsDynamicCast<JSSVGFontFaceFormatElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGFontFaceFormatElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGFontFaceFormatElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGFontFaceFormatElementPrototype* domObject = jsDynamicCast<JSSVGFontFaceFormatElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGFontFaceFormatElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFontFaceFormatElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGFontFaceFormatElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGFontFaceFormatElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}

#endif // ENABLE(SVG_FONTS)
