/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLException.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSQLExceptionCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLExceptionMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLExceptionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSQLExceptionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSQLExceptionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSQLExceptionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLExceptionPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLExceptionPrototype>(vm.heap)) JSSQLExceptionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLExceptionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSQLException> JSSQLExceptionConstructor;

/* Hash table */

static const struct CompactHashIndex JSSQLExceptionTableIndex[4] = {
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { 1, -1 },
};


static const HashTableValue JSSQLExceptionTableValues[] =
{
    { "code", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "message", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSSQLExceptionTable = { 2, 3, true, JSSQLExceptionTableValues, JSSQLExceptionTableIndex };
/* Hash table for constructor */

static const HashTableValue JSSQLExceptionConstructorTableValues[] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "DATABASE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "VERSION_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "QUOTA_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SYNTAX_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "TIMEOUT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
};

template<> JSValue JSSQLExceptionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLExceptionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSQLException::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SQLException"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSQLExceptionConstructorTableValues, *this);
}

template<> const ClassInfo JSSQLExceptionConstructor::s_info = { "SQLException", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLExceptionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSQLExceptionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSQLExceptionConstructor) } },
    { "UNKNOWN_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "DATABASE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "VERSION_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "QUOTA_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SYNTAX_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "TIMEOUT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
};

const ClassInfo JSSQLExceptionPrototype::s_info = { "SQLExceptionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLExceptionPrototype) };

void JSSQLExceptionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLExceptionPrototypeTableValues, *this);
}

const ClassInfo JSSQLException::s_info = { "SQLException", &Base::s_info, &JSSQLExceptionTable, CREATE_METHOD_TABLE(JSSQLException) };

JSSQLException::JSSQLException(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLException>&& impl)
    : JSDOMWrapper<SQLException>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSQLException::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSQLExceptionPrototype::create(vm, globalObject, JSSQLExceptionPrototype::createStructure(vm, globalObject, globalObject->errorPrototype()));
}

JSObject* JSSQLException::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLException>(vm, globalObject);
}

void JSSQLException::destroy(JSC::JSCell* cell)
{
    JSSQLException* thisObject = static_cast<JSSQLException*>(cell);
    thisObject->JSSQLException::~JSSQLException();
}

bool JSSQLException::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSSQLException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSSQLException, Base>(state, JSSQLExceptionTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsSQLExceptionCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLException*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLException", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.code());
    return JSValue::encode(result);
}


EncodedJSValue jsSQLExceptionMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLException*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLException", "message");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.message());
    return JSValue::encode(result);
}


EncodedJSValue jsSQLExceptionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSQLExceptionPrototype* domObject = jsDynamicCast<JSSQLExceptionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSQLException::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSQLExceptionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSQLExceptionPrototype* domObject = jsDynamicCast<JSSQLExceptionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSQLException::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLExceptionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSQLExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLException = jsCast<JSSQLException*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLException->wrapped(), jsSQLException);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLException* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSQLException>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLException* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLException>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLException.
    COMPILE_ASSERT(!__is_polymorphic(SQLException), SQLException_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSSQLException>(globalObject, impl);
}

SQLException* JSSQLException::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLException*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
