/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformanceTiming.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsPerformanceTimingNavigationStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingUnloadEventStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingUnloadEventEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRedirectStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRedirectEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingFetchStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomainLookupStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomainLookupEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingConnectStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingConnectEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingSecureConnectionStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRequestStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingResponseStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingResponseEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomLoading(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomInteractive(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomContentLoadedEventStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomContentLoadedEventEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomComplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingLoadEventStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingLoadEventEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPerformanceTimingConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPerformanceTimingPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPerformanceTimingPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceTimingPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceTimingPrototype>(vm.heap)) JSPerformanceTimingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceTimingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSPerformanceTiming> JSPerformanceTimingConstructor;

template<> JSValue JSPerformanceTimingConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceTimingConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceTiming::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("PerformanceTiming"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSPerformanceTimingConstructor::s_info = { "PerformanceTiming", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceTimingConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceTimingPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceTimingConstructor) } },
    { "navigationStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingNavigationStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "unloadEventStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "unloadEventEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fetchStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingFetchStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "secureConnectionStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingSecureConnectionStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "requestStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRequestStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domLoading", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomLoading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domInteractive", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomInteractive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domContentLoadedEventStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domContentLoadedEventEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domComplete", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomComplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loadEventStart", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loadEventEnd", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSPerformanceTimingPrototype::s_info = { "PerformanceTimingPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceTimingPrototype) };

void JSPerformanceTimingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceTimingPrototypeTableValues, *this);
}

const ClassInfo JSPerformanceTiming::s_info = { "PerformanceTiming", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceTiming) };

JSPerformanceTiming::JSPerformanceTiming(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceTiming>&& impl)
    : JSDOMWrapper<PerformanceTiming>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPerformanceTiming::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPerformanceTimingPrototype::create(vm, globalObject, JSPerformanceTimingPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSPerformanceTiming::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformanceTiming>(vm, globalObject);
}

void JSPerformanceTiming::destroy(JSC::JSCell* cell)
{
    JSPerformanceTiming* thisObject = static_cast<JSPerformanceTiming*>(cell);
    thisObject->JSPerformanceTiming::~JSPerformanceTiming();
}

EncodedJSValue jsPerformanceTimingNavigationStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "navigationStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.navigationStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingUnloadEventStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "unloadEventStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.unloadEventStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingUnloadEventEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "unloadEventEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.unloadEventEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingRedirectStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "redirectStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.redirectStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingRedirectEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "redirectEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.redirectEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingFetchStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "fetchStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.fetchStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomainLookupStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domainLookupStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domainLookupStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomainLookupEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domainLookupEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domainLookupEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingConnectStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "connectStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.connectStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingConnectEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "connectEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.connectEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingSecureConnectionStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "secureConnectionStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.secureConnectionStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingRequestStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "requestStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.requestStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingResponseStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "responseStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.responseStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingResponseEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "responseEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.responseEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomLoading(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domLoading");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domLoading());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomInteractive(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domInteractive");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domInteractive());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomContentLoadedEventStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domContentLoadedEventStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domContentLoadedEventStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomContentLoadedEventEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domContentLoadedEventEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domContentLoadedEventEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingDomComplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "domComplete");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.domComplete());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingLoadEventStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "loadEventStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.loadEventStart());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingLoadEventEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceTiming*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceTiming", "loadEventEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.loadEventEnd());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTimingConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSPerformanceTimingPrototype* domObject = jsDynamicCast<JSPerformanceTimingPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSPerformanceTiming::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSPerformanceTimingConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPerformanceTimingPrototype* domObject = jsDynamicCast<JSPerformanceTimingPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSPerformanceTiming::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceTimingConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSPerformanceTimingOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceTimingOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceTiming = jsCast<JSPerformanceTiming*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceTiming->wrapped(), jsPerformanceTiming);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceTiming@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17PerformanceTimingE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, PerformanceTiming* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPerformanceTiming>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, PerformanceTiming* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformanceTiming>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PerformanceTiming@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17PerformanceTimingE[2];
#if COMPILER(CLANG)
    // If this fails PerformanceTiming does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PerformanceTiming), PerformanceTiming_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PerformanceTiming has subclasses. If PerformanceTiming has subclasses that get passed
    // to toJS() we currently require PerformanceTiming you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSPerformanceTiming>(globalObject, impl);
}

PerformanceTiming* JSPerformanceTiming::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceTiming*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_TIMING)
