/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSLocation.h"

#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMStringList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsLocationHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsLocationAncestorOrigins(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

typedef JSDOMConstructorNotConstructable<JSLocation> JSLocationConstructor;

/* Hash table */

static const struct CompactHashIndex JSLocationTableIndex[35] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, 34 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { 0, 32 },
    { 5, 33 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { 1, -1 },
    { -1, -1 },
    { 4, -1 },
    { 13, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 6, -1 },
    { 12, -1 },
};


static const HashTableValue JSLocationTableValues[] =
{
    { "href", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHref) } },
    { "protocol", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationProtocol) } },
    { "host", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHost) } },
    { "hostname", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHostname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHostname) } },
    { "port", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationPort) } },
    { "pathname", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationPathname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationPathname) } },
    { "search", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationSearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationSearch) } },
    { "hash", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHash) } },
    { "origin", DontDelete | ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ancestorOrigins", DontDelete | ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationAncestorOrigins), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "assign", DontDelete | ReadOnly | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsLocationInstanceFunctionAssign), (intptr_t) (1) } },
    { "replace", DontDelete | ReadOnly | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsLocationInstanceFunctionReplace), (intptr_t) (1) } },
    { "reload", DontDelete | ReadOnly | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsLocationInstanceFunctionReload), (intptr_t) (0) } },
    { "toString", DontDelete | ReadOnly | DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsLocationInstanceFunctionToString), (intptr_t) (0) } },
};

static const HashTable JSLocationTable = { 14, 31, true, JSLocationTableValues, JSLocationTableIndex };
template<> JSValue JSLocationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSLocationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSLocation::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Location"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSLocationConstructor::s_info = { "Location", &Base::s_info, 0, CREATE_METHOD_TABLE(JSLocationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSLocationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationConstructor) } },
};

const ClassInfo JSLocationPrototype::s_info = { "LocationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSLocationPrototype) };

void JSLocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSLocationPrototypeTableValues, *this);
}

void JSLocationPrototype::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSLocationPrototype*>(cell);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

const ClassInfo JSLocation::s_info = { "Location", &Base::s_info, &JSLocationTable, CREATE_METHOD_TABLE(JSLocation) };

JSLocation::JSLocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Location>&& impl)
    : JSDOMWrapper<Location>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSLocation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSLocationPrototype::create(vm, globalObject, JSLocationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSLocation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSLocation>(vm, globalObject);
}

void JSLocation::destroy(JSC::JSCell* cell)
{
    JSLocation* thisObject = static_cast<JSLocation*>(cell);
    thisObject->JSLocation::~JSLocation();
}

bool JSLocation::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSLocation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    if (getStaticPropertySlot<JSLocation, Base>(state, JSLocationTable, thisObject, propertyName, slot))
        return true;
    return false;
}

bool JSLocation::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSLocation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsLocationHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.href());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationProtocol(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "protocol");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.protocol());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationHost(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "host");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.host());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationHostname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "hostname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hostname());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationPort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "port");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.port());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationPathname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "pathname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pathname());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationSearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "search");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.search());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationHash(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "hash");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hash());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "origin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.origin());
    return JSValue::encode(result);
}


EncodedJSValue jsLocationAncestorOrigins(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Location", "ancestorOrigins");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.ancestorOrigins()));
    return JSValue::encode(result);
}


EncodedJSValue jsLocationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSLocationPrototype* domObject = jsDynamicCast<JSLocationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSLocation::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSLocationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSLocationPrototype* domObject = jsDynamicCast<JSLocationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSLocation::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSLocation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSLocation::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSLocation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    PutPropertySlot slot(thisObject, shouldThrow);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

void setJSLocationHref(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "href");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHref(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationProtocol(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "protocol");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setProtocol(activeDOMWindow(state), firstDOMWindow(state), nativeValue, ec);
    setDOMException(state, ec);
}


void setJSLocationHost(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "host");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHost(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationHostname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "hostname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHostname(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationPort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "port");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPort(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationPathname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "pathname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPathname(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationSearch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "search");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSearch(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSLocationHash(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSLocation* castedThis = jsDynamicCast<JSLocation*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Location", "hash");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHash(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


JSValue JSLocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSLocationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionAssign(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSLocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Location", "assign");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSLocation::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.assign(activeDOMWindow(state), firstDOMWindow(state), url);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionReplace(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSLocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Location", "replace");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSLocation::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.replace(activeDOMWindow(state), firstDOMWindow(state), url);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionReload(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSLocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Location", "reload");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSLocation::info());
    auto& impl = castedThis->wrapped();
    impl.reload(activeDOMWindow(state));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSLocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Location", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSLocation::info());
    return JSValue::encode(castedThis->toStringFunction(*state));
}

bool JSLocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsLocation = jsCast<JSLocation*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsLocation->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSLocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsLocation = jsCast<JSLocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsLocation->wrapped(), jsLocation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Location@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8LocationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Location* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSLocation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Location* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSLocation>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Location@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore8LocationE[2];
#if COMPILER(CLANG)
    // If this fails Location does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Location), Location_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Location has subclasses. If Location has subclasses that get passed
    // to toJS() we currently require Location you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSLocation>(globalObject, impl);
}

Location* JSLocation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSLocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
