/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSHTMLVideoElement_h
#define JSHTMLVideoElement_h

#if ENABLE(VIDEO)

#include "HTMLVideoElement.h"
#include "JSHTMLMediaElement.h"
#include "JSNode.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSHTMLVideoElement : public JSHTMLMediaElement {
public:
    typedef JSHTMLMediaElement Base;
    static JSHTMLVideoElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<HTMLVideoElement>&& impl)
    {
        JSHTMLVideoElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLVideoElement>(globalObject->vm().heap)) JSHTMLVideoElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static const bool hasStaticPropertyTable = false;

    static JSC::JSObject* createPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static JSC::JSObject* getPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static HTMLVideoElement* toWrapped(JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    HTMLVideoElement& wrapped() const
    {
        return static_cast<HTMLVideoElement&>(Base::wrapped());
    }
protected:
    JSHTMLVideoElement(JSC::Structure*, JSDOMGlobalObject&, Ref<HTMLVideoElement>&&);

    void finishCreation(JSC::VM& vm)
    {
        Base::finishCreation(vm);
        ASSERT(inherits(info()));
    }

};

class JSHTMLVideoElementOwner : public JSNodeOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, HTMLVideoElement*)
{
    static NeverDestroyed<JSHTMLVideoElementOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(HTMLVideoElement* wrappableObject)
{
    return wrappableObject;
}



} // namespace WebCore

#endif // ENABLE(VIDEO)

#endif
