/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMParser.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocument.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMParserPrototypeFunctionParseFromString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMParserConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMParserConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMParserPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMParserPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMParserPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMParserPrototype>(vm.heap)) JSDOMParserPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMParserPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDOMParser> JSDOMParserConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSDOMParserConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMParserConstructor*>(state->callee());
    RefPtr<DOMParser> object = DOMParser::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSDOMParserConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMParserConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMParser::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DOMParser"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMParserConstructor::s_info = { "DOMParser", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMParserConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMParserPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMParserConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMParserConstructor) } },
    { "parseFromString", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMParserPrototypeFunctionParseFromString), (intptr_t) (0) } },
};

const ClassInfo JSDOMParserPrototype::s_info = { "DOMParserPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMParserPrototype) };

void JSDOMParserPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMParserPrototypeTableValues, *this);
}

const ClassInfo JSDOMParser::s_info = { "DOMParser", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMParser) };

JSDOMParser::JSDOMParser(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMParser>&& impl)
    : JSDOMWrapper<DOMParser>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMParser::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMParserPrototype::create(vm, globalObject, JSDOMParserPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMParser::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMParser>(vm, globalObject);
}

void JSDOMParser::destroy(JSC::JSCell* cell)
{
    JSDOMParser* thisObject = static_cast<JSDOMParser*>(cell);
    thisObject->JSDOMParser::~JSDOMParser();
}

EncodedJSValue jsDOMParserConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMParserPrototype* domObject = jsDynamicCast<JSDOMParserPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMParser::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMParserConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMParserPrototype* domObject = jsDynamicCast<JSDOMParserPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDOMParser::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMParserConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMParserPrototypeFunctionParseFromString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMParser*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMParser", "parseFromString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMParser::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String str = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String contentType = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parseFromString(str, contentType, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSDOMParserOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMParserOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMParser = jsCast<JSDOMParser*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMParser->wrapped(), jsDOMParser);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMParser* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMParser>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMParser* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMParser>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMParser.
    COMPILE_ASSERT(!__is_polymorphic(DOMParser), DOMParser_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSDOMParser>(globalObject, impl);
}

DOMParser* JSDOMParser::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMParser*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
