/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRule.h"

#include "CSSRule.h"
#include "CSSStyleSheet.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSCSSStyleSheet.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCSSRuleType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSRuleCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSRuleParentStyleSheet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleParentRule(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSRulePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSRulePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSRulePrototype>(vm.heap)) JSCSSRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSRule> JSCSSRuleConstructor;

/* Hash table for constructor */

static const HashTableValue JSCSSRuleConstructorTableValues[] =
{
    { "UNKNOWN_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "STYLE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHARSET_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "IMPORT_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "FONT_FACE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PAGE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "KEYFRAMES_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "KEYFRAME_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SUPPORTS_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "WEBKIT_REGION_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "WEBKIT_KEYFRAMES_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "WEBKIT_KEYFRAME_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
};


COMPILE_ASSERT(0 == CSSRule::UNKNOWN_RULE, CSSRuleEnumUNKNOWN_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSRule::STYLE_RULE, CSSRuleEnumSTYLE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSRule::CHARSET_RULE, CSSRuleEnumCHARSET_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSRule::IMPORT_RULE, CSSRuleEnumIMPORT_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == CSSRule::MEDIA_RULE, CSSRuleEnumMEDIA_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == CSSRule::FONT_FACE_RULE, CSSRuleEnumFONT_FACE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == CSSRule::PAGE_RULE, CSSRuleEnumPAGE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == CSSRule::KEYFRAMES_RULE, CSSRuleEnumKEYFRAMES_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == CSSRule::KEYFRAME_RULE, CSSRuleEnumKEYFRAME_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(12 == CSSRule::SUPPORTS_RULE, CSSRuleEnumSUPPORTS_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == CSSRule::WEBKIT_REGION_RULE, CSSRuleEnumWEBKIT_REGION_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == CSSRule::WEBKIT_KEYFRAMES_RULE, CSSRuleEnumWEBKIT_KEYFRAMES_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == CSSRule::WEBKIT_KEYFRAME_RULE, CSSRuleEnumWEBKIT_KEYFRAME_RULEIsWrongUseDoNotCheckConstants);

template<> JSValue JSCSSRuleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSRuleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSRule::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSRule"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSCSSRuleConstructorTableValues, *this);
}

template<> const ClassInfo JSCSSRuleConstructor::s_info = { "CSSRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRuleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSRulePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSRuleConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cssText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleCssText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSRuleCssText) } },
    { "parentStyleSheet", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentStyleSheet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parentRule", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentRule), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "UNKNOWN_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "STYLE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHARSET_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "IMPORT_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "FONT_FACE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PAGE_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "KEYFRAMES_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "KEYFRAME_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SUPPORTS_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "WEBKIT_REGION_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "WEBKIT_KEYFRAMES_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "WEBKIT_KEYFRAME_RULE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
};

const ClassInfo JSCSSRulePrototype::s_info = { "CSSRulePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRulePrototype) };

void JSCSSRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSRule::s_info = { "CSSRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRule) };

JSCSSRule::JSCSSRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSRule>&& impl)
    : JSDOMWrapper<CSSRule>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSRule::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSRulePrototype::create(vm, globalObject, JSCSSRulePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCSSRule::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSRule>(vm, globalObject);
}

void JSCSSRule::destroy(JSC::JSCell* cell)
{
    JSCSSRule* thisObject = static_cast<JSCSSRule*>(cell);
    thisObject->JSCSSRule::~JSCSSRule();
}

EncodedJSValue jsCSSRuleType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSRule", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSRuleCssText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSRule", "cssText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.cssText());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSRuleParentStyleSheet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSRule", "parentStyleSheet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentStyleSheet()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSRuleParentRule(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSRule", "parentRule");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentRule()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSRuleConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSRulePrototype* domObject = jsDynamicCast<JSCSSRulePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSRule::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSRuleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSRulePrototype* domObject = jsDynamicCast<JSCSSRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCSSRuleCssText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSRule* castedThis = jsDynamicCast<JSCSSRule*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSRule", "cssText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCssText(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSCSSRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRuleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSRule::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCSSRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSCSSRuleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsCSSRule = jsCast<JSCSSRule*>(handle.slot()->asCell());
    void* root = WebCore::root(&jsCSSRule->wrapped());
    return visitor.containsOpaqueRoot(root);
}

void JSCSSRuleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSRule = jsCast<JSCSSRule*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSRule->wrapped(), jsCSSRule);
}

CSSRule* JSCSSRule::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSRule*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
