/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSCharsetRule.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCSSCharsetRuleEncoding(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSCharsetRuleEncoding(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSCharsetRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSCharsetRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSCharsetRulePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSCharsetRulePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSCharsetRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSCharsetRulePrototype>(vm.heap)) JSCSSCharsetRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSCharsetRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSCharsetRule> JSCSSCharsetRuleConstructor;

template<> JSValue JSCSSCharsetRuleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSCharsetRuleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSCharsetRule::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSCharsetRule"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCSSCharsetRuleConstructor::s_info = { "CSSCharsetRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSCharsetRuleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSCharsetRulePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSCharsetRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSCharsetRuleConstructor) } },
    { "encoding", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSCharsetRuleEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSCharsetRuleEncoding) } },
};

const ClassInfo JSCSSCharsetRulePrototype::s_info = { "CSSCharsetRulePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSCharsetRulePrototype) };

void JSCSSCharsetRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSCharsetRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSCharsetRule::s_info = { "CSSCharsetRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSCharsetRule) };

JSCSSCharsetRule::JSCSSCharsetRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSCharsetRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSCharsetRule::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSCharsetRulePrototype::create(vm, globalObject, JSCSSCharsetRulePrototype::createStructure(vm, globalObject, JSCSSRule::getPrototype(vm, globalObject)));
}

JSObject* JSCSSCharsetRule::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSCharsetRule>(vm, globalObject);
}

EncodedJSValue jsCSSCharsetRuleEncoding(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSCharsetRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSCharsetRule", "encoding");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.encoding());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSCharsetRuleConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSCharsetRulePrototype* domObject = jsDynamicCast<JSCSSCharsetRulePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSCharsetRule::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSCharsetRuleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSCharsetRulePrototype* domObject = jsDynamicCast<JSCSSCharsetRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCSSCharsetRuleEncoding(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSCharsetRule* castedThis = jsDynamicCast<JSCSSCharsetRule*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSCharsetRule", "encoding");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setEncoding(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSCSSCharsetRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSCharsetRuleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
