/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioNode.h"

#include "AudioContext.h"
#include "ExceptionCode.h"
#include "JSAudioContext.h"
#include "JSAudioNode.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionDisconnect(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsAudioNodeContext(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeNumberOfInputs(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeNumberOfOutputs(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeChannelCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioNodeChannelCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeChannelCountMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioNodeChannelCountMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeChannelInterpretation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioNodeChannelInterpretation(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioNodePrototype>(vm.heap)) JSAudioNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioNode> JSAudioNodeConstructor;

template<> JSValue JSAudioNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioNodeConstructor::s_info = { "AudioNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeConstructor) } },
    { "context", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeContext), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "numberOfInputs", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeNumberOfInputs), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "numberOfOutputs", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeNumberOfOutputs), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "channelCount", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelCount) } },
    { "channelCountMode", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelCountMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelCountMode) } },
    { "channelInterpretation", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelInterpretation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelInterpretation) } },
    { "connect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioNodePrototypeFunctionConnect), (intptr_t) (1) } },
    { "disconnect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioNodePrototypeFunctionDisconnect), (intptr_t) (0) } },
};

const ClassInfo JSAudioNodePrototype::s_info = { "AudioNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioNodePrototype) };

void JSAudioNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioNode::s_info = { "AudioNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioNode) };

JSAudioNode::JSAudioNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioNode>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioNodePrototype::create(vm, globalObject, JSAudioNodePrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSAudioNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioNode>(vm, globalObject);
}

EncodedJSValue jsAudioNodeContext(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "context");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.context()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeNumberOfInputs(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "numberOfInputs");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.numberOfInputs());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeNumberOfOutputs(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "numberOfOutputs");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.numberOfOutputs());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeChannelCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "channelCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.channelCount());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeChannelCountMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "channelCountMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.channelCountMode());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeChannelInterpretation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioNode", "channelInterpretation");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.channelInterpretation());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioNodePrototype* domObject = jsDynamicCast<JSAudioNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioNodePrototype* domObject = jsDynamicCast<JSAudioNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioNodeChannelCount(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioNode* castedThis = jsDynamicCast<JSAudioNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioNode", "channelCount");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setChannelCount(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSAudioNodeChannelCountMode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioNode* castedThis = jsDynamicCast<JSAudioNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioNode", "channelCountMode");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setChannelCountMode(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSAudioNodeChannelInterpretation(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioNode* castedThis = jsDynamicCast<JSAudioNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioNode", "channelInterpretation");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setChannelInterpretation(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSAudioNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

static EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioNode", "connect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    AudioNode* destination = JSAudioNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned output = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned input = toUInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.connect(destination, output, input, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioNode", "connect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    AudioParam* destination = JSAudioParam::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned output = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.connect(destination, output, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect(ExecState* state)
{
    size_t argsCount = std::min<size_t>(3, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSAudioNode::info())))) || (argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSAudioNode::info())))) || (argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSAudioNode::info())))))
        return jsAudioNodePrototypeFunctionConnect1(state);
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSAudioParam::info())))) || (argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSAudioParam::info())))))
        return jsAudioNodePrototypeFunctionConnect2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionDisconnect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioNode", "disconnect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioNode::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned output = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.disconnect(output, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSAudioNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSAudioNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsAudioNode = jsCast<JSAudioNode*>(handle.slot()->asCell());
    if (jsAudioNode->wrapped().isFiringEventListeners())
        return true;
    AudioNode* root = &jsAudioNode->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSAudioNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioNode = jsCast<JSAudioNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioNode->wrapped(), jsAudioNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9AudioNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9AudioNodeE[2];
#if COMPILER(CLANG)
    // If this fails AudioNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioNode), AudioNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioNode has subclasses. If AudioNode has subclasses that get passed
    // to toJS() we currently require AudioNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAudioNode>(globalObject, impl);
}

AudioNode* JSAudioNode::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
