# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_rebuildctl_global_optspecs
	string join \n v/verbose H/endpoint= c/config= C/color h/help V/version
end

function __fish_rebuildctl_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_rebuildctl_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_rebuildctl_using_subcommand
	set -l cmd (__fish_rebuildctl_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s H -l endpoint -d 'rebuilderd endpoint to talk to' -r
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s c -l config -d 'Configuration file path' -r -F
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -s V -l version -d 'Print version'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -f -a "status" -d 'Show worker status'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -f -a "pkgs" -d 'Package related subcommands'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -f -a "queue" -d 'Queue related subcommands'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c rebuildctl -n "__fish_rebuildctl_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand status" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand status" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand status" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "sync" -d 'Sync package index'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "ls" -d 'List known packages'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "sync-profile" -d 'Sync package index with profile'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "sync-stdin" -d 'Read a package sync from stdin'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "requeue" -d 'Requeue a given package'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "log" -d 'Access the build log of the last rebuild'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "diffoscope" -d 'Access the diffoscope of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "attestation" -d 'Access the attestation of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and not __fish_seen_subcommand_from sync ls sync-profile sync-stdin requeue log diffoscope attestation help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l architecture -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l maintainer -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l release -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l pkg -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l exclude -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l sync-method -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -l print-json
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l name -d 'Filter packages matching this name' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l status -d 'Filter packages matching this status' -r -f -a "GOOD\t''
BAD\t''
UNKWN\t''"
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l distro -d 'Filter packages matching this distro' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l suite -d 'Filter packages matching this suite' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l architecture -d 'Filter packages matching this architecture' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -l json
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-profile" -l sync-config -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-profile" -l print-json
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-profile" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-profile" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-profile" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-stdin" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-stdin" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from sync-stdin" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l name -d 'Filter packages matching this name' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l status -d 'Filter packages matching this status' -r -f -a "GOOD\t''
BAD\t''
UNKWN\t''"
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l distro -d 'Filter packages matching this distro' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l suite -d 'Filter packages matching this suite' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l architecture -d 'Filter packages matching this architecture' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l priority -d 'Requeue with given priority' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -l reset -d 'Reset the status back to UNKWN'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from requeue" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -l name -d 'Filter packages matching this name' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -l status -d 'Filter packages matching this status' -r -f -a "GOOD\t''
BAD\t''
UNKWN\t''"
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -l distro -d 'Filter packages matching this distro' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -l suite -d 'Filter packages matching this suite' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -l architecture -d 'Filter packages matching this architecture' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from log" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -l name -d 'Filter packages matching this name' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -l status -d 'Filter packages matching this status' -r -f -a "GOOD\t''
BAD\t''
UNKWN\t''"
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -l distro -d 'Filter packages matching this distro' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -l suite -d 'Filter packages matching this suite' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -l architecture -d 'Filter packages matching this architecture' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from diffoscope" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -l name -d 'Filter packages matching this name' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -l status -d 'Filter packages matching this status' -r -f -a "GOOD\t''
BAD\t''
UNKWN\t''"
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -l distro -d 'Filter packages matching this distro' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -l suite -d 'Filter packages matching this suite' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -l architecture -d 'Filter packages matching this architecture' -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from attestation" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "sync" -d 'Sync package index'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "ls" -d 'List known packages'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "sync-profile" -d 'Sync package index with profile'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "sync-stdin" -d 'Read a package sync from stdin'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "requeue" -d 'Requeue a given package'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "log" -d 'Access the build log of the last rebuild'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "diffoscope" -d 'Access the diffoscope of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "attestation" -d 'Access the attestation of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand pkgs; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -f -a "ls" -d 'List the current build queue'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -f -a "push" -d 'Add a new task to the queue manually'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -f -a "drop" -d 'Drop packages from queue matching given filter'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and not __fish_seen_subcommand_from ls push drop help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from ls" -l head
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from ls" -l json
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from ls" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from ls" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from push" -l architecture -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from push" -l priority -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from push" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from push" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from push" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from drop" -l architecture -r
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from drop" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from drop" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from drop" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from help" -f -a "ls" -d 'List the current build queue'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from help" -f -a "push" -d 'Add a new task to the queue manually'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from help" -f -a "drop" -d 'Drop packages from queue matching given filter'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand queue; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand completions" -s v -l verbose -d 'Verbose logging'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand completions" -s C -l color -d 'Bypass tty detection and always use colors'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand completions" -s h -l help -d 'Print help'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and not __fish_seen_subcommand_from status pkgs queue completions help" -f -a "status" -d 'Show worker status'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and not __fish_seen_subcommand_from status pkgs queue completions help" -f -a "pkgs" -d 'Package related subcommands'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and not __fish_seen_subcommand_from status pkgs queue completions help" -f -a "queue" -d 'Queue related subcommands'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and not __fish_seen_subcommand_from status pkgs queue completions help" -f -a "completions" -d 'Generate shell completions'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and not __fish_seen_subcommand_from status pkgs queue completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "sync" -d 'Sync package index'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "ls" -d 'List known packages'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "sync-profile" -d 'Sync package index with profile'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "sync-stdin" -d 'Read a package sync from stdin'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "requeue" -d 'Requeue a given package'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "log" -d 'Access the build log of the last rebuild'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "diffoscope" -d 'Access the diffoscope of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from pkgs" -f -a "attestation" -d 'Access the attestation of the last rebuild (if there is any)'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from queue" -f -a "ls" -d 'List the current build queue'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from queue" -f -a "push" -d 'Add a new task to the queue manually'
complete -c rebuildctl -n "__fish_rebuildctl_using_subcommand help; and __fish_seen_subcommand_from queue" -f -a "drop" -d 'Drop packages from queue matching given filter'
