/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.CharClassRaw;
import com.plantuml.ubrex.CharSet;
import com.plantuml.ubrex.TextNavigator;
import java.util.EnumSet;
import java.util.Set;

public class ChallengeCharSet
implements Challenge {
    private final Set<CharClassRaw> charClasses = EnumSet.noneOf(CharClassRaw.class);
    private final CharSet charSet = new CharSet();
    private boolean reversed = false;

    public static ChallengeCharSet build(CharSequence pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Empty!");
        }
        if (pattern.charAt(pattern.length() - 1) == '\u301c') {
            throw new IllegalArgumentException("Range operator '\u301c' must be followed by a character.");
        }
        ChallengeCharSet result = new ChallengeCharSet();
        TextNavigator nav = TextNavigator.build(pattern);
        while (nav.length() > 0) {
            char ch = nav.charAt(0);
            if (ch == '\u3024') {
                result.reversed = true;
            } else if (ch != ' ') {
                if (ch == '\u3034') {
                    nav.jump(1);
                    CharClassRaw charClass = CharClassRaw.fromDefinition(nav);
                    result.charClasses.add(charClass);
                    nav.jump(charClass.getDefinitionLength() - 1);
                } else if (nav.length() > 2 && nav.charAt(1) == '\u301c') {
                    nav.jump(2);
                    char end = nav.charAt(0);
                    result.addRange(ch, end);
                } else if (ch == '\u3003') {
                    result.addChar('\"');
                } else {
                    result.addChar(ch);
                }
            }
            nav.jump(1);
        }
        return result;
    }

    public void addChar(char ch) {
        this.charSet.addChar(ch);
    }

    public void addRange(char start, char end) {
        this.charSet.addRange(start, end);
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        if (string.length() == position) {
            return new ChallengeResult(Integer.MIN_VALUE);
        }
        char ch = string.charAt(position);
        if ((this.charSet.contains(ch) || CharClassRaw.internalMatchesAny(this.charClasses, ch)) != this.reversed) {
            return new ChallengeResult(1);
        }
        return new ChallengeResult(Integer.MIN_VALUE);
    }
}

