/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.saml;

import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;

public class SamlFilesystemMetadataResolver
extends FilesystemMetadataResolver {
    SamlFilesystemMetadataResolver(String filePath, Settings opensearchSettings, Path configPath) throws Exception {
        super(SamlFilesystemMetadataResolver.getMetadataFile(filePath, opensearchSettings, configPath));
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(() -> SamlFilesystemMetadataResolver.super.fetchMetadata());
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static File getMetadataFile(String filePath, Settings settings, Path configPath) {
        Environment env = new Environment(settings, configPath);
        return env.configDir().resolve(filePath).toAbsolutePath().toFile();
    }
}

