/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import java.time.LocalDate;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import mediathek.daten.DatenFilm;
import mediathek.gui.expiration.SenderExpirationService;
import mediathek.tool.datum.DateUtil;
import org.jetbrains.annotations.NotNull;

class FilmAvailableUntilWorker
extends SwingWorker<LocalDate, Integer> {
    private final DatenFilm currentFilm;
    private final JLabel lblAvailableUntil;

    public FilmAvailableUntilWorker(@NotNull DatenFilm currentFilm, @NotNull JLabel lblAvailableUntil) {
        this.currentFilm = currentFilm;
        this.lblAvailableUntil = lblAvailableUntil;
        lblAvailableUntil.setText("Suche...");
    }

    @Override
    protected LocalDate doInBackground() {
        return SenderExpirationService.fetchExpiryDate(this.currentFilm.getSender(), this.currentFilm.getWebsiteUrl());
    }

    @Override
    protected void done() {
        try {
            LocalDate result2 = (LocalDate)this.get();
            if (result2 != null) {
                this.lblAvailableUntil.setText(DateUtil.FORMATTER.format(result2));
                this.currentFilm.setAvailableUntil(result2);
            } else {
                this.lblAvailableUntil.setText("");
                this.currentFilm.setAvailableUntil(null);
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            // empty catch block
        }
    }
}

