/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;

public class GTKColorType
extends ColorType {
    public static final ColorType LIGHT = new GTKColorType("Light");
    public static final ColorType DARK = new GTKColorType("Dark");
    public static final ColorType MID = new GTKColorType("Mid");
    public static final ColorType BLACK = new GTKColorType("Black");
    public static final ColorType WHITE = new GTKColorType("White");
    public static final int MAX_COUNT;
    private static final float[] HLS_COLORS;
    private static final Object HLS_COLOR_LOCK;

    private static int hlsToRGB(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7 = f2 <= 0.5f ? f2 * (1.0f + f3) : f2 + f3 - f2 * f3;
        float f8 = 2.0f * f2 - f7;
        if ((double)f3 == 0.0) {
            if ((double)f == 0.0) {
                f5 = f6 = f2;
                f4 = f6;
            } else {
                f6 = 0.0f;
                f5 = 0.0f;
                f4 = 0.0f;
            }
        } else {
            f4 = GTKColorType.hlsValue(f8, f7, f + 120.0f);
            f5 = GTKColorType.hlsValue(f8, f7, f);
            f6 = GTKColorType.hlsValue(f8, f7, f - 120.0f);
        }
        return (int)(f4 * 255.0f) << 16 | (int)((double)f5 * 255.0) << 8 | (int)(f6 * 255.0f);
    }

    private static float hlsValue(float f, float f2, float f3) {
        if (f3 > 360.0f) {
            f3 -= 360.0f;
        } else if (f3 < 0.0f) {
            f3 += 360.0f;
        }
        if (f3 < 60.0f) {
            return f + (f2 - f) * f3 / 60.0f;
        }
        if (f3 < 180.0f) {
            return f2;
        }
        if (f3 < 240.0f) {
            return f + (f2 - f) * (240.0f - f3) / 60.0f;
        }
        return f;
    }

    private static float[] rgbToHLS(int n, float[] fArray) {
        float f = (float)((n & 0xFF0000) >> 16) / 255.0f;
        float f2 = (float)((n & 0xFF00) >> 8) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        float f4 = Math.max(Math.max(f, f2), f3);
        float f5 = Math.min(Math.min(f, f2), f3);
        float f6 = (f4 + f5) / 2.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (f4 != f5) {
            float f9 = f4 - f5;
            float f10 = f7 = f6 <= 0.5f ? f9 / (f4 + f5) : f9 / (2.0f - f4 - f5);
            f8 = f == f4 ? (f2 - f3) / f9 : (f2 == f4 ? 2.0f + (f3 - f) / f9 : 4.0f + (f - f2) / f9);
            if ((f8 *= 60.0f) < 0.0f) {
                f8 += 360.0f;
            }
        }
        if (fArray == null) {
            fArray = new float[]{f8, f6, f7};
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Color adjustColor(Color color, float f, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        Object object = HLS_COLOR_LOCK;
        synchronized (object) {
            float[] fArray = GTKColorType.rgbToHLS(color.getRGB(), HLS_COLORS);
            f6 = fArray[0];
            f5 = fArray[1];
            f4 = fArray[2];
        }
        f6 = Math.min(360.0f, f * f6);
        f5 = Math.min(1.0f, f2 * f5);
        f4 = Math.min(1.0f, f3 * f4);
        return new ColorUIResource(GTKColorType.hlsToRGB(f6, f5, f4));
    }

    protected GTKColorType(String string) {
        super(string);
    }

    static {
        HLS_COLORS = new float[3];
        HLS_COLOR_LOCK = new Object();
        MAX_COUNT = WHITE.getID() + 1;
    }
}

