/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class Tool {
    private static final Log log = LogFactory.getLog(Tool.class);
    private static boolean ant = false;
    private static final String catalinaHome = System.getProperty("catalina.home");
    private static boolean common = false;
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] stringArray) {
        Object object;
        Object[] objectArray;
        Object object2;
        Serializable serializable;
        if (catalinaHome == null) {
            log.error((Object)"Must set 'catalina.home' system property");
            System.exit(1);
        }
        int n = 0;
        block20: while (true) {
            if (n == stringArray.length) {
                Tool.usage();
                System.exit(1);
            }
            switch (stringArray[n]) {
                case "-ant": {
                    ant = true;
                    break;
                }
                case "-common": {
                    common = true;
                    break;
                }
                case "-server": {
                    server = true;
                    break;
                }
                case "-shared": {
                    shared = true;
                    break;
                }
                default: {
                    break block20;
                }
            }
            ++n;
        }
        if (ant) {
            System.setProperty("ant.home", catalinaHome);
        }
        Object object3 = null;
        try {
            serializable = new ArrayList<File>();
            object2 = new ArrayList<File>();
            object2.add(new File(catalinaHome, "classes"));
            serializable.add(new File(catalinaHome, "lib"));
            if (common) {
                object2.add(new File(catalinaHome, "common" + File.separator + "classes"));
                serializable.add(new File(catalinaHome, "common" + File.separator + "lib"));
            }
            if (server) {
                object2.add(new File(catalinaHome, "server" + File.separator + "classes"));
                serializable.add(new File(catalinaHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                object2.add(new File(catalinaHome, "shared" + File.separator + "classes"));
                serializable.add(new File(catalinaHome, "shared" + File.separator + "lib"));
            }
            object3 = ClassLoaderFactory.createClassLoader(object2.toArray(new File[0]), serializable.toArray(new File[0]), null);
        }
        catch (Throwable throwable) {
            Bootstrap.handleThrowable(throwable);
            log.error((Object)"Class loader creation threw exception", throwable);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)object3);
        serializable = null;
        object2 = stringArray[n++];
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading application class " + (String)object2));
            }
            serializable = ((ClassLoader)object3).loadClass((String)object2);
        }
        catch (Throwable throwable) {
            Bootstrap.handleThrowable(throwable);
            log.error((Object)("Exception creating instance of " + (String)object2), throwable);
            System.exit(1);
        }
        Method method = null;
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Identifying main() method");
            }
            objectArray = "main";
            object = new Class[]{stringArray2.getClass()};
            method = ((Class)serializable).getMethod((String)objectArray, (Class<?>)object);
        }
        catch (Throwable throwable) {
            Bootstrap.handleThrowable(throwable);
            log.error((Object)"Exception locating main() method", throwable);
            System.exit(1);
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Calling main() method");
            }
            objectArray = new Object[]{stringArray2};
            method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            object = Bootstrap.unwrapInvocationTargetException(throwable);
            Bootstrap.handleThrowable((Throwable)object);
            log.error((Object)"Exception calling main() method", (Throwable)object);
            System.exit(1);
        }
    }

    private static void usage() {
        log.info((Object)"Usage:  java org.apache.catalina.startup.Tool [<options>] <class> [<arguments>]");
    }
}

