/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.KggHashGenerator;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.SQLUtil;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public class OracleShardingKeyImpl
implements OracleShardingKey {
    private static final int DEFAULT_CHAR_CHARSET = 873;
    private static final int DEFAULT_NCHAR_CHARSET = 2000;
    private static final long ORA_HASH_MAX_VALUE = 0x100000000L;
    private final Datum[] subKeys;
    private final ShardingMetadata.SubKeyMetadata[] defaultSubKeyMetadata;
    private boolean isSuperShardingKey;
    private final long shardKeyOraHash;
    private final int hashCode;
    private static final NullShardingKeyType NULL_SHARD_KEY_LOW;
    private static final NullShardingKeyType NULL_SHARD_KEY_HIGH;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    protected OracleShardingKeyImpl(OracleShardingKeyBuilderImpl builder) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$21, null, builder);
            }
            this.isSuperShardingKey = false;
            List<Object> keyObjects = builder.subKeyObjects();
            List<SQLType> keyType = builder.subKeyTypes();
            int size = Math.min(keyObjects.size(), keyType.size());
            Datum[] aDatum = new Datum[size];
            ShardingMetadata.SubKeyMetadata[] aSubKeyMetadata = new ShardingMetadata.SubKeyMetadata[size];
            int tempHashCode = 1;
            for (int i2 = 0; i2 < size; ++i2) {
                Object subkey = keyObjects.get(i2);
                SQLType subkeyType = keyType.get(i2);
                int subKeyCharSet = -1;
                try {
                    Datum subKeyData;
                    if (!(subkey instanceof NullShardingKeyType)) {
                        subKeyCharSet = OracleShardingKeyImpl.getDefaultSubKeyCharSet(subkeyType.getVendorTypeNumber());
                        Class<? extends Datum> subKeyClass = this.getSubKeyDataClass(subkeyType.getVendorTypeNumber());
                        subKeyData = JavaToJavaConverter.convert(subkey, subKeyClass, null, null, CharacterSet.make(subKeyCharSet));
                    } else {
                        subKeyData = (NullShardingKeyType)subkey;
                    }
                    aDatum[i2] = subKeyData;
                    tempHashCode = 31 * tempHashCode + (subKeyData == null ? 0 : ((Datum)subKeyData).bytesHashCode());
                    aSubKeyMetadata[i2] = new ShardingMetadata.SubKeyMetadata(i2, subkeyType, subKeyCharSet);
                    continue;
                }
                catch (SQLException e2) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception while processing sub key type " + e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$21, null, illegalArgumentException);
                    }
                    throw illegalArgumentException;
                }
            }
            this.subKeys = aDatum;
            this.defaultSubKeyMetadata = aSubKeyMetadata;
            this.hashCode = tempHashCode;
            this.shardKeyOraHash = builder.getOraHash();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$21, null);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$21, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markSuperShardingKey(boolean bl) {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isSuperShardingKey;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$0, this, bl);
            }
            this.isSuperShardingKey = isSuperShardingKey;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isSuperShardingKey() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean bl2 = this.isSuperShardingKey;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(OracleShardingKey oracleShardingKey) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void o2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, oracleShardingKey);
            }
            if (o2 == this) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                }
                return 0;
            }
            if (!(o2 instanceof OracleShardingKeyImpl)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Sharding Keys being compared are not of the same type");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            OracleShardingKeyImpl key = (OracleShardingKeyImpl)o2;
            if (this.shardKeyOraHash != -1L && key.shardKeyOraHash != -1L) {
                int n3;
                int n4 = this.shardKeyOraHash < key.shardKeyOraHash ? -1 : (n3 = this.shardKeyOraHash == key.shardKeyOraHash ? 0 : 1);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                }
                return n4;
            }
            if (this.subKeys.length != key.subKeys.length) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Sharding Keys being compared are not of the same type");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            for (int i2 = 0; i2 < this.subKeys.length; ++i2) {
                Datum o1 = this.subKeys[i2];
                Datum o22 = key.subKeys[i2];
                if (o1 instanceof NullShardingKeyType && o22 instanceof NullShardingKeyType) continue;
                if (o1 instanceof NullShardingKeyType) {
                    if (((NullShardingKeyType)o1).isShardingKeyHigh()) {
                        int n5 = 1;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n5);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                        }
                        return 1;
                    }
                    int n6 = -1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                    }
                    return -1;
                }
                if (o22 instanceof NullShardingKeyType) {
                    if (((NullShardingKeyType)o22).isShardingKeyHigh()) {
                        int n7 = -1;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n7);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                        }
                        return -1;
                    }
                    int n8 = 1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n8);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                    }
                    return 1;
                }
                int isEqual = Datum.compareBytes(o1.getBytes(), o22.getBytes());
                if (isEqual == 0) continue;
                int n9 = isEqual;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n9);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
                }
                return n9;
            }
            int n10 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, n10);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        try {
            return this.toString(null);
        }
        catch (SQLException e2) {
            return null;
        }
    }

    @DisableTrace
    public String toString(Connection conn) throws SQLException {
        if (this.subKeys == null || this.subKeys.length == 0) {
            return "";
        }
        StringBuffer keyStr = new StringBuffer();
        for (int i2 = 0; i2 < this.subKeys.length; ++i2) {
            Datum key = this.subKeys[i2];
            if (key instanceof TIMESTAMPLTZ) {
                if (conn != null) {
                    keyStr.append(((TIMESTAMPLTZ)key).stringValue(conn));
                } else {
                    keyStr.append(key.toString());
                }
            } else {
                keyStr.append(key.stringValue());
            }
            if (i2 + 1 >= this.subKeys.length) continue;
            keyStr.append(",");
        }
        return keyStr.toString();
    }

    @DisableTrace
    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof OracleShardingKeyImpl)) {
            return false;
        }
        OracleShardingKeyImpl otherKey = (OracleShardingKeyImpl)otherObj;
        return Arrays.equals(this.subKeys, otherKey.subKeys);
    }

    @DisableTrace
    public int hashCode() {
        return this.hashCode;
    }

    public String encodeKeyinB64Format() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$3, this, new Object[0]);
            }
            String string = new Encoder().encodeKey(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long shardKeyOraHash(ShardingMetadata shardingMetadata) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void metadata;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, shardingMetadata);
            }
            if (metadata == null) {
                long l2 = -1L;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, l2);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, null);
                }
                return -1L;
            }
            if (this.shardKeyOraHash != -1L) {
                long l3 = this.shardKeyOraHash;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, l3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, null);
                }
                return l3;
            }
            List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadata = this.isSuperShardingKey() ? metadata.getSuperShardingKeyColumns() : metadata.getShardingKeyColumns();
            List<Datum> listSubKeys = Arrays.asList(this.subKeys);
            long oraHash = listSubKeys.stream().filter(datum -> {
                boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
                try {
                    Datum k2;
                    boolean bl2;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$15, null, datum);
                    }
                    boolean bl3 = bl2 = k2 != null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$15, null, bl2);
                        ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$15, null, null);
                    }
                    return bl3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$15, null, throwable2);
                    }
                    throw throwable;
                }
            }).map(datum -> {
                boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
                try {
                    void listSubKeys;
                    List dbSubKeyMetadata;
                    void k2;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$14, null, dbSubKeyMetadata, listSubKeys, datum);
                    }
                    byte[] byArray = OracleShardingKeyImpl.encodeInDBCharset((Datum)k2, ((ShardingMetadata.SubKeyMetadata)dbSubKeyMetadata.get(listSubKeys.indexOf(k2))).getCharSet());
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$14, null, byArray);
                        ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$14, null, null);
                    }
                    return byArray;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$14, null, throwable2);
                    }
                    throw throwable;
                }
            }).mapToLong(byArray -> {
                boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
                try {
                    byte[] k2;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$13, null, byArray);
                    }
                    long l2 = Integer.toUnsignedLong(KggHashGenerator.hash(k2));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$13, null, l2);
                        ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$13, null, null);
                    }
                    return l2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$13, null, throwable2);
                    }
                    throw throwable;
                }
            }).sum();
            long l4 = oraHash % 0x100000000L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, l4);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public long getShardingKeyOraHash() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$5, this, new Object[0]);
            }
            long l2 = this.shardKeyOraHash;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$5, this, l2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$5, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(ShardingMetadata shardingMetadata) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadata;
            void metadata;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, shardingMetadata);
            }
            if (metadata == null) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, null);
                }
                return true;
            }
            List<ShardingMetadata.SubKeyMetadata> list = dbSubKeyMetadata = this.isSuperShardingKey() ? metadata.getSuperShardingKeyColumns() : metadata.getShardingKeyColumns();
            if (dbSubKeyMetadata == null) {
                IllegalStateException illegalStateException = new IllegalStateException("Database metadata is not populated");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, illegalStateException);
                }
                throw illegalStateException;
            }
            if (dbSubKeyMetadata.size() != this.subKeys.length) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, null);
                }
                return false;
            }
            ListIterator<ShardingMetadata.SubKeyMetadata> metaIt = dbSubKeyMetadata.listIterator();
            for (int i2 = 0; metaIt.hasNext() && i2 < this.subKeys.length; ++i2) {
                ShardingMetadata.SubKeyMetadata keyMeta = metaIt.next();
                Datum subKey = this.subKeys[i2];
                if (this.getSubKeyDataClass(keyMeta.getDataType().getVendorTypeNumber()).equals(subKey.getClass())) continue;
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, null);
                }
                return false;
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private static int getDefaultSubKeyCharSet(int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int dataType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, n2);
            }
            if (dataType == 12 || dataType == 1) {
                int n3 = 873;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, n3);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, null);
                }
                return 873;
            }
            if (dataType == -9 || dataType == -15) {
                int n4 = 2000;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, n4);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, null);
                }
                return 2000;
            }
            int n5 = -1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, n5);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, null);
            }
            return -1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class<? extends Datum> getSubKeyDataClass(int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dataType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$8, this, n2);
            }
            Class subKeyClass = null;
            switch (dataType) {
                case 1: 
                case 12: {
                    subKeyClass = CHAR.class;
                    break;
                }
                case -15: 
                case -9: {
                    subKeyClass = CHAR.class;
                    break;
                }
                case 2: 
                case 6: {
                    subKeyClass = NUMBER.class;
                    break;
                }
                case 91: {
                    subKeyClass = DATE.class;
                    break;
                }
                case 93: {
                    subKeyClass = TIMESTAMP.class;
                    break;
                }
                case -102: {
                    subKeyClass = TIMESTAMPLTZ.class;
                    break;
                }
                case -2: {
                    subKeyClass = RAW.class;
                    break;
                }
                default: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported Type of sharding key ");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$8, this, illegalArgumentException);
                    }
                    throw illegalArgumentException;
                }
            }
            Class clazz = subKeyClass;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$8, this, clazz);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$8, this, null);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<OracleShardingKeyImpl> decodeKeys(InputStream inputStream, ShardingMetadata shardingMetadata, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isKeyHigh;
            void isSuperKey;
            InputStream keysData;
            void metadata;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$9, null, inputStream, shardingMetadata, bl, bl2);
            }
            List<OracleShardingKeyImpl> list = new Decoder((ShardingMetadata)metadata).decodeKey(keysData, (boolean)isSuperKey, (boolean)isKeyHigh);
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$9, null, list);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$9, null, null);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] encodeInDBCharset(Datum datum, int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            Datum encodedSubKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$10, null, datum, n2);
            }
            try {
                void dbCharSet;
                Datum subKey;
                encodedSubKey = subKey instanceof CHAR ? new CHAR(subKey.toString(), CharacterSet.make((int)dbCharSet)) : subKey;
            }
            catch (SQLException e2) {
                IllegalStateException illegalStateException = new IllegalStateException("Invalid sharding key Character set specification in database", e2);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$10, null, illegalStateException);
                }
                throw illegalStateException;
            }
            byte[] byArray = encodedSubKey.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$10, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$10, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] decodeInStandardCharset(byte[] byArray, int n2, SQLType sQLType) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] defaultEncodedKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$11, null, byArray, n2, sQLType);
            }
            try {
                void dbDataType;
                switch ((OracleType)dbDataType) {
                    case VARCHAR2: 
                    case CHAR: 
                    case NVARCHAR: 
                    case NCHAR: {
                        void dbCharSet;
                        byte[] dbEncodedKey;
                        CHAR charKey = new CHAR(dbEncodedKey, CharacterSet.make((int)dbCharSet));
                        defaultEncodedKey = new CHAR(charKey.getString(), CharacterSet.make(OracleShardingKeyImpl.getDefaultSubKeyCharSet(dbDataType.getVendorTypeNumber()))).getBytes();
                        break;
                    }
                    default: {
                        byte[] dbEncodedKey;
                        defaultEncodedKey = dbEncodedKey;
                        break;
                    }
                }
            }
            catch (SQLException e2) {
                IllegalStateException illegalStateException = new IllegalStateException("Invalid sharding key Character set specification in database", e2);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$11, null, illegalStateException);
                }
                throw illegalStateException;
            }
            byte[] byArray2 = defaultEncodedKey;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$11, null, byArray2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$11, null, null);
            }
            return defaultEncodedKey;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static /* synthetic */ Datum[] access$000(OracleShardingKeyImpl oracleShardingKeyImpl) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleShardingKeyImpl x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$16, null, oracleShardingKeyImpl);
            }
            Datum[] datumArray = x0.subKeys;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$16, null, datumArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$16, null, null);
            }
            return x0.subKeys;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ ShardingMetadata.SubKeyMetadata[] access$100(OracleShardingKeyImpl oracleShardingKeyImpl) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleShardingKeyImpl x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$17, null, oracleShardingKeyImpl);
            }
            ShardingMetadata.SubKeyMetadata[] subKeyMetadataArray = x0.defaultSubKeyMetadata;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$17, null, subKeyMetadataArray);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$17, null, null);
            }
            return x0.defaultSubKeyMetadata;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ NullShardingKeyType access$200() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$18, null, new Object[0]);
            }
            NullShardingKeyType nullShardingKeyType = NULL_SHARD_KEY_HIGH;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$18, null, nullShardingKeyType);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$18, null, null);
            }
            return nullShardingKeyType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ NullShardingKeyType access$300() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$19, null, new Object[0]);
            }
            NullShardingKeyType nullShardingKeyType = NULL_SHARD_KEY_LOW;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$19, null, nullShardingKeyType);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$19, null, null);
            }
            return nullShardingKeyType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$400(byte[] byArray, int n2, SQLType sQLType) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            void x1;
            byte[] x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$20, null, byArray, n2, sQLType);
            }
            byte[] byArray2 = OracleShardingKeyImpl.decodeInStandardCharset(x0, (int)x1, (SQLType)x2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$20, null, byArray2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$20, null, null);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleShardingKeyImpl.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$21 = OracleShardingKeyImpl.class.getDeclaredConstructor(OracleShardingKeyBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$20 = OracleShardingKeyImpl.class.getDeclaredMethod("access$400", byte[].class, Integer.TYPE, SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$19 = OracleShardingKeyImpl.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$18 = OracleShardingKeyImpl.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$17 = OracleShardingKeyImpl.class.getDeclaredMethod("access$100", OracleShardingKeyImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$16 = OracleShardingKeyImpl.class.getDeclaredMethod("access$000", OracleShardingKeyImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$15 = OracleShardingKeyImpl.class.getDeclaredMethod("lambda$shardKeyOraHash$0", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$14 = OracleShardingKeyImpl.class.getDeclaredMethod("lambda$shardKeyOraHash$1", List.class, List.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$13 = OracleShardingKeyImpl.class.getDeclaredMethod("lambda$shardKeyOraHash$2", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$12 = OracleShardingKeyImpl.class.getDeclaredMethod("compareTo", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$11 = OracleShardingKeyImpl.class.getDeclaredMethod("decodeInStandardCharset", byte[].class, Integer.TYPE, SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$10 = OracleShardingKeyImpl.class.getDeclaredMethod("encodeInDBCharset", Datum.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$9 = OracleShardingKeyImpl.class.getDeclaredMethod("decodeKeys", InputStream.class, ShardingMetadata.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$8 = OracleShardingKeyImpl.class.getDeclaredMethod("getSubKeyDataClass", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$7 = OracleShardingKeyImpl.class.getDeclaredMethod("getDefaultSubKeyCharSet", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$6 = OracleShardingKeyImpl.class.getDeclaredMethod("isValid", ShardingMetadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$5 = OracleShardingKeyImpl.class.getDeclaredMethod("getShardingKeyOraHash", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$4 = OracleShardingKeyImpl.class.getDeclaredMethod("shardKeyOraHash", ShardingMetadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$3 = OracleShardingKeyImpl.class.getDeclaredMethod("encodeKeyinB64Format", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$2 = OracleShardingKeyImpl.class.getDeclaredMethod("compareTo", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$1 = OracleShardingKeyImpl.class.getDeclaredMethod("isSuperShardingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        try {
            $$$methodRef$$$0 = OracleShardingKeyImpl.class.getDeclaredMethod("markSuperShardingKey", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.pool");
        NULL_SHARD_KEY_LOW = new NullShardingKeyType(false);
        NULL_SHARD_KEY_HIGH = new NullShardingKeyType(true);
    }

    private static class NullShardingKeyType
    extends Datum {
        final boolean isHighKey;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        private NullShardingKeyType(boolean isHighKey) {
            this.isHighKey = isHighKey;
        }

        boolean isShardingKeyHigh() {
            return this.isHighKey;
        }

        @Override
        public String stringValue() {
            return this.isHighKey ? "MAX" : "MIN";
        }

        @Override
        @DisableTrace
        public boolean equals(Object obj) {
            return obj instanceof NullShardingKeyType;
        }

        @Override
        public int bytesHashCode() {
            return "NULL".hashCode();
        }

        public boolean isConvertibleTo(Class cls) {
            return false;
        }

        @Override
        public Object toJdbc() throws SQLException {
            return null;
        }

        @Override
        public Object makeJdbcArray(int arraySize) {
            return null;
        }

        public int hashCode() {
            return this.bytesHashCode();
        }

        static {
            try {
                $$$methodRef$$$8 = NullShardingKeyType.class.getDeclaredConstructor(Boolean.TYPE, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = NullShardingKeyType.class.getDeclaredConstructor(Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = NullShardingKeyType.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = NullShardingKeyType.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = NullShardingKeyType.class.getDeclaredMethod("toJdbc", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = NullShardingKeyType.class.getDeclaredMethod("isConvertibleTo", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = NullShardingKeyType.class.getDeclaredMethod("bytesHashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = NullShardingKeyType.class.getDeclaredMethod("stringValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = NullShardingKeyType.class.getDeclaredMethod("isShardingKeyHigh", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class Decoder {
        private final ShardingMetadata dbMetadata;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public Decoder(ShardingMetadata metadata) {
            if (metadata == null) {
                throw new IllegalStateException("sharding key Metadata is null or not initialized");
            }
            this.dbMetadata = metadata;
        }

        List<OracleShardingKeyImpl> decodeBase64Key(String encodedShardKey, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            if (encodedShardKey == null || encodedShardKey.length() == 0) {
                return null;
            }
            List<byte[]> subKeysByteArr = null;
            int keybodyIndex = encodedShardKey.indexOf(",");
            if (keybodyIndex < 0) {
                return null;
            }
            String keyBody = encodedShardKey.substring(keybodyIndex + 1);
            if (keyBody.isEmpty()) {
                return null;
            }
            List<String> subkeyStrings = Arrays.asList(keyBody.split(","));
            if (subkeyStrings.size() <= 0) {
                return null;
            }
            subKeysByteArr = subkeyStrings.stream().filter(k2 -> k2 != null).map(k2 -> Base64.getDecoder().decode((String)k2)).collect(Collectors.toList());
            return this.buildShardKeys(subKeysByteArr, isSuperShardingKey, isHighKey);
        }

        List<OracleShardingKeyImpl> decodeKey(InputStream inStream, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            ShardingKeyReader reader = new ShardingKeyReader(inStream);
            List<byte[]> subKeysByteArr = reader.hasKeys() ? reader.getKeys() : null;
            return this.buildShardKeys(subKeysByteArr, isSuperShardingKey, isHighKey);
        }

        public List<OracleShardingKeyImpl> buildShardKeys(List<byte[]> subKeysByteArr, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            byte[] defaultEncodedKey;
            ArrayList<OracleShardingKeyImpl> decodedKeyList = new ArrayList<OracleShardingKeyImpl>();
            List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadataList = isSuperShardingKey ? this.dbMetadata.getSuperShardingKeyColumns() : this.dbMetadata.getShardingKeyColumns();
            ShardingMetadata.ShardingType shardType = isSuperShardingKey ? this.dbMetadata.getSuperShardingType() : this.dbMetadata.getShardingType();
            OracleShardingKeyBuilderImpl bldr = null;
            if (subKeysByteArr == null || subKeysByteArr.size() <= 0) {
                throw new IllegalStateException("Null sharding key values in database");
            }
            if (shardType == ShardingMetadata.ShardingType.HASH) {
                bldr = new OracleShardingKeyBuilderImpl();
                OracleShardingKeyImpl hashedKey = null;
                byte[] hashedKeyByteVal = subKeysByteArr.get(0);
                hashedKey = hashedKeyByteVal.length > 0 ? bldr.subkey(subKeysByteArr.get(0), OracleType.NUMBER).oraHash(NUMBER.toLong(subKeysByteArr.get(0))).build() : bldr.subkey(isHighKey ? OracleShardingKeyImpl.access$200() : OracleShardingKeyImpl.access$300(), OracleType.ANYDATA).build();
                if (hashedKey != null) {
                    hashedKey.markSuperShardingKey(isSuperShardingKey);
                    decodedKeyList.add(hashedKey);
                }
                return decodedKeyList;
            }
            ListIterator<ShardingMetadata.SubKeyMetadata> metadataItr = dbSubKeyMetadataList.listIterator();
            bldr = new OracleShardingKeyBuilderImpl();
            if (shardType == ShardingMetadata.ShardingType.RANGE) {
                if (subKeysByteArr.size() != dbSubKeyMetadataList.size()) {
                    throw new IllegalStateException("Mismatch in Sharding database metadata and sharding key values");
                }
                List standardEncodedKeys = subKeysByteArr.stream().map(k2 -> {
                    int keyIdx = subKeysByteArr.indexOf(k2);
                    ShardingMetadata.SubKeyMetadata meta = (ShardingMetadata.SubKeyMetadata)dbSubKeyMetadataList.get(keyIdx);
                    return OracleShardingKeyImpl.access$400(k2, meta.getCharSet(), meta.getDataType());
                }).collect(Collectors.toList());
                ListIterator keysItr = standardEncodedKeys.listIterator();
                while (metadataItr.hasNext() && keysItr.hasNext()) {
                    defaultEncodedKey = (byte[])keysItr.next();
                    ShardingMetadata.SubKeyMetadata dbSubKeyMetadata = metadataItr.next();
                    if (defaultEncodedKey.length == 0) {
                        bldr.subkey(isHighKey ? OracleShardingKeyImpl.access$200() : OracleShardingKeyImpl.access$300(), OracleType.ANYDATA);
                        continue;
                    }
                    bldr.subkey(defaultEncodedKey, dbSubKeyMetadata.getDataType());
                }
                OracleShardingKeyImpl newKey = bldr.build();
                newKey.markSuperShardingKey(isSuperShardingKey);
                decodedKeyList.add(newKey);
            }
            if (shardType == ShardingMetadata.ShardingType.LIST) {
                ListIterator<byte[]> keysItr = subKeysByteArr.listIterator();
                while (keysItr.hasNext()) {
                    while (metadataItr.hasNext()) {
                        ShardingMetadata.SubKeyMetadata dbSubKeyMetadata = metadataItr.next();
                        defaultEncodedKey = OracleShardingKeyImpl.access$400(keysItr.next(), dbSubKeyMetadata.getCharSet(), dbSubKeyMetadata.getDataType());
                        bldr.subkey(defaultEncodedKey, dbSubKeyMetadata.getDataType());
                    }
                    OracleShardingKeyImpl newKey = bldr.build();
                    newKey.markSuperShardingKey(isSuperShardingKey);
                    decodedKeyList.add(newKey);
                    bldr = new OracleShardingKeyBuilderImpl();
                    metadataItr = dbSubKeyMetadataList.listIterator();
                }
            }
            return decodedKeyList;
        }

        static {
            try {
                $$$methodRef$$$6 = Decoder.class.getDeclaredConstructor(ShardingMetadata.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Decoder.class.getDeclaredMethod("lambda$decodeBase64Key$0", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Decoder.class.getDeclaredMethod("lambda$decodeBase64Key$1", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Decoder.class.getDeclaredMethod("lambda$buildShardKeys$2", List.class, List.class, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Decoder.class.getDeclaredMethod("buildShardKeys", List.class, Boolean.TYPE, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Decoder.class.getDeclaredMethod("decodeKey", InputStream.class, Boolean.TYPE, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Decoder.class.getDeclaredMethod("decodeBase64Key", String.class, Boolean.TYPE, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }

        private class ShardingKeyReader {
            private final InputStream stream;
            private boolean hasKeys = false;
            private static final int KDKLBLEN = 128;
            private static final int KDKLNULL = 255;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            public ShardingKeyReader(InputStream stream) {
                this.stream = stream;
                if (stream != null) {
                    this.hasKeys = true;
                }
            }

            public boolean hasKeys() {
                return this.hasKeys;
            }

            public List<byte[]> getKeys() {
                if (!this.hasKeys) {
                    return null;
                }
                ArrayList<byte[]> keys = new ArrayList<byte[]>();
                while (this.hasNext()) {
                    keys.add(this.next());
                }
                this.hasKeys = false;
                return keys;
            }

            private boolean hasNext() {
                try {
                    return this.stream.available() > 0;
                }
                catch (IOException e2) {
                    this.hasKeys = false;
                    return false;
                }
            }

            private byte[] next() {
                try {
                    int len = this.stream.read();
                    if (len == 255) {
                        len = 0;
                    } else if (len >= 128) {
                        len = (len - 128 << 8) + this.stream.read();
                    }
                    byte[] value = new byte[len];
                    this.stream.read(value);
                    return value;
                }
                catch (IOException e2) {
                    this.hasKeys = false;
                    return null;
                }
            }

            static {
                try {
                    $$$methodRef$$$4 = ShardingKeyReader.class.getDeclaredConstructor(Decoder.class, InputStream.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = ShardingKeyReader.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = ShardingKeyReader.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = ShardingKeyReader.class.getDeclaredMethod("getKeys", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = ShardingKeyReader.class.getDeclaredMethod("hasKeys", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
    }

    static class Encoder {
        private static final int TNS_HEADER_VERSION = 1;
        private final String headerVersionTypeStr;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        Encoder() {
            int tnsHeaderType = 0;
            this.headerVersionTypeStr = "1 " + tnsHeaderType;
        }

        String encodeKey(OracleShardingKey shardKeyToEncode) throws SQLException {
            String encodedStr = "";
            if (shardKeyToEncode == null) {
                return "";
            }
            OracleShardingKeyImpl shardKey = null;
            if (!(shardKeyToEncode instanceof OracleShardingKeyImpl)) {
                throw new IllegalArgumentException("Invalid type of sharding key for Encoding");
            }
            shardKey = (OracleShardingKeyImpl)shardKeyToEncode;
            if (OracleShardingKeyImpl.access$000(shardKey).length == 0) {
                return "";
            }
            String header = null;
            header = Arrays.asList(OracleShardingKeyImpl.access$100(shardKey)).stream().filter(k2 -> k2 != null).map(k2 -> {
                try {
                    return SQLUtil.getInternalType(k2.getDataType().getVendorTypeNumber()) + "";
                }
                catch (SQLException e2) {
                    throw new IllegalArgumentException("Invalid sharding key data type");
                }
            }).reduce(this.headerVersionTypeStr, (x2, y2) -> {
                x2 = x2 + " " + y2;
                return x2;
            });
            encodedStr = Arrays.asList(OracleShardingKeyImpl.access$000(shardKey)).stream().filter(k2 -> k2 != null).map(k2 -> Base64.getEncoder().encodeToString(k2.getBytes())).reduce(header, (x2, y2) -> {
                x2 = x2 + "," + y2;
                return x2;
            });
            return encodedStr;
        }

        static {
            try {
                $$$methodRef$$$7 = Encoder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Encoder.class.getDeclaredMethod("lambda$encodeKey$0", ShardingMetadata.SubKeyMetadata.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Encoder.class.getDeclaredMethod("lambda$encodeKey$1", ShardingMetadata.SubKeyMetadata.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Encoder.class.getDeclaredMethod("lambda$encodeKey$2", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Encoder.class.getDeclaredMethod("lambda$encodeKey$3", Datum.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Encoder.class.getDeclaredMethod("lambda$encodeKey$4", Datum.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Encoder.class.getDeclaredMethod("lambda$encodeKey$5", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Encoder.class.getDeclaredMethod("encodeKey", OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

