/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.bytecode.BytecodeFrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLFrameInfo;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.bytecode.BytecodeLocation;
import com.oracle.truffle.api.bytecode.ContinuationResult;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenerator})
public final class GeneratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GeneratorBuiltinsSlotsGen.SLOTS;

    private static void checkResumable(Node inliningTarget, PGenerator self, PRaiseNode raiseNode) {
        if (self.isFinished()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.StopIteration);
        }
        if (self.isRunning()) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
        }
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GeneratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PGenerator self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<generator object %s at 0x%d>", self.getQualname(), PythonAbstractObject.objectHashCode(self));
        }
    }

    @Builtin(name="gi_suspended", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetSuspendedNode
    extends PythonUnaryBuiltinNode {
        GetSuspendedNode() {
        }

        @Specialization
        static boolean suspended(PGenerator self) {
            return self.isStarted() && !self.isRunning() && !self.isFinished();
        }
    }

    @Builtin(name="gi_yieldfrom", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetYieldFromNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getYieldFrom(PGenerator self) {
            Object yieldFrom = self.getYieldFrom();
            return yieldFrom != null ? yieldFrom : PNone.NONE;
        }
    }

    @Builtin(name="gi_frame", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFrameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getFrame(PGenerator self) {
            if (self.isFinished()) {
                return PNone.NONE;
            }
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                ContinuationResult continuation = self.getContinuation();
                BytecodeLocation location = continuation.getBytecodeLocation();
                MaterializedFrame generatorFrame = continuation.getFrame();
                BytecodeDSLFrameInfo info = (BytecodeDSLFrameInfo)generatorFrame.getFrameDescriptor().getInfo();
                PFrame frame = MaterializeFrameNode.materializeGeneratorFrame((Node)location.getBytecodeNode(), generatorFrame, PFrame.Reference.EMPTY);
                int bci = location.getBytecodeIndex();
                frame.setBci(bci);
                frame.setLine(info.getRootNode().bciToLine(bci, location.getBytecodeNode()));
                return frame;
            }
            MaterializedFrame generatorFrame = PArguments.getGeneratorFrame(self.getArguments());
            BytecodeFrameInfo info = (BytecodeFrameInfo)generatorFrame.getFrameDescriptor().getInfo();
            PFrame frame = MaterializeFrameNode.materializeGeneratorFrame((Node)info.getRootNode(), generatorFrame, PFrame.Reference.EMPTY);
            int bci = self.getBci();
            frame.setBci(bci);
            frame.setLine(info.getRootNode().bciToLine(bci));
            return frame;
        }
    }

    @Builtin(name="gi_running", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class GetRunningNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object getRunning(PGenerator self, PNone none) {
            return self.isRunning();
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object setRunning(PGenerator self, Object obj, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, "gi_running", self);
        }
    }

    @Builtin(name="gi_code", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCodeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getCode(PGenerator self, @Bind Node inliningTarget, @Cached InlinedConditionProfile hasCodeProfile) {
            return self.getOrCreateCode(inliningTarget, hasCodeProfile);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PGenerator self, @Bind Node inliningTarget, @Cached CommonGeneratorBuiltins.ResumeGeneratorNode resumeGeneratorNode, @Cached PRaiseNode raiseNode) {
            if (self.isFinished()) {
                throw NextNode.iteratorExhausted();
            }
            if (self.isRunning()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
            }
            return resumeGeneratorNode.execute(frame, inliningTarget, self, null);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PGenerator self) {
            return self;
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class QualnameNode
    extends PythonBinaryBuiltinNode {
        QualnameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static Object getQualname(PGenerator self, PNone noValue) {
            return self.getQualname();
        }

        @Specialization
        static Object setQualname(PGenerator self, TruffleString value) {
            self.setQualname(value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setQualname(PGenerator self, Object value, @Bind Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast) {
            return QualnameNode.setQualname(self, cast.cast(inliningTarget, value, ErrorMessages.MUST_BE_SET_TO_S_OBJ, SpecialAttributeNames.T___QUALNAME__, "string"));
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonBinaryBuiltinNode {
        NameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static Object getName(PGenerator self, PNone noValue) {
            return self.getName();
        }

        @Specialization
        static Object setName(PGenerator self, TruffleString value) {
            self.setName(value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setName(PGenerator self, Object value, @Bind Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast) {
            return NameNode.setName(self, cast.cast(inliningTarget, value, ErrorMessages.MUST_BE_SET_TO_S_OBJ, SpecialAttributeNames.T___NAME__, "string"));
        }
    }
}

