/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.hashlib.HashObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.hashlib.HashObjectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.HashlibHash, PythonBuiltinClassType.HashlibHmac})
public final class HashObjectBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = HashObjectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return HashObjectBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, DigestObject self, @Bind Node inliningTarget, @Cached ObjectNodes.GetFullyQualifiedClassNameNode getFullyQualifiedClassNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString fqcn = getFullyQualifiedClassNameNode.execute((Frame)frame, inliningTarget, self);
            return simpleTruffleStringFormatNode.format("<%s %s object @ 0x%s>", self.getAlgorithm(), fqcn, PythonAbstractNativeObject.systemHashCodeAsHexString(self));
        }
    }
}

