/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class CharCopyingBinder
extends Binder {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    CharCopyingBinder() {
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        int len;
        int fromCharOffset;
        char[] fromChars;
        if (bindUseDBA) {
            return OraclePreparedStatement.theStaticDBACopyingBinder.bind(stmt, bindPosition, rankInBuffer, rank, bindBytes, bindChars, bindIndicators, bytePitch, charPitch, byteoffset, charoffset, lenoffset, indoffset, clearPriorBindValues, localCheckSum, bindData, bindDataOffsets, bindDataLengths, bindDataIndex, bindUseDBA, formOfUse);
        }
        if (rankInBuffer == 0) {
            fromChars = stmt.lastBoundChars;
            fromCharOffset = stmt.lastBoundCharOffsets[bindPosition];
            bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
            bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
            if (fromChars == bindChars && fromCharOffset == charoffset) {
                if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
                    if (bindIndicators[indoffset] == -1) {
                        localCheckSum = CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
                    } else {
                        int len2 = stmt.lastBoundCharLens[bindPosition];
                        localCheckSum = CRC64.updateChecksum(localCheckSum, fromChars, fromCharOffset, len2);
                    }
                }
                return localCheckSum;
            }
            len = stmt.lastBoundCharLens[bindPosition];
            if (len > charPitch) {
                len = charPitch;
            }
        } else {
            fromChars = bindChars;
            fromCharOffset = charoffset - charPitch;
            bindIndicators[indoffset] = bindIndicators[indoffset - 1];
            bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
            len = charPitch;
        }
        System.arraycopy(fromChars, fromCharOffset, bindChars, charoffset, len);
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, fromChars, fromCharOffset, len);
        }
        return localCheckSum;
    }

    static {
        try {
            $$$methodRef$$$2 = CharCopyingBinder.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CharCopyingBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CharCopyingBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

