/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder
implements PartialSide {
    private int _sides = 15;
    private int _roundedCornerSize = 5;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public PartialLineBorder(Color color, int thickness, boolean roundedCorners) {
        super(color, thickness, roundedCorners);
    }

    public PartialLineBorder(Color color, int thickness, boolean roundedCorners, int roundedCornerSize) {
        super(color, thickness, roundedCorners);
        this._roundedCornerSize = roundedCornerSize;
    }

    public PartialLineBorder(Color color, int thickness, int side) {
        super(color, thickness);
        this._sides = side;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public int getRoundedCornerSize() {
        return this._roundedCornerSize;
    }

    public void setRoundedCornerSize(int roundedCornerSize) {
        this._roundedCornerSize = roundedCornerSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (this._sides == 15) {
                if (!this.roundedCorners) {
                    g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    continue;
                }
                Object o = JideSwingUtilities.setupShapeAntialiasing(g);
                g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this._roundedCornerSize, this._roundedCornerSize);
                JideSwingUtilities.restoreShapeAntialiasing(g, o);
                continue;
            }
            if ((this._sides & 1) != 0) {
                g.drawLine(x, y + i, x + width - 1, y + i);
            }
            if ((this._sides & 2) != 0) {
                g.drawLine(x, y + height - i - 1, x + width - 1, y + height - i - 1);
            }
            if ((this._sides & 8) != 0) {
                g.drawLine(x + i, y, x + i, y + height - 1);
            }
            if ((this._sides & 4) == 0) continue;
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets borderInsets = super.getBorderInsets(c);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c, insets);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }
}

