/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen.allgemein;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import mediathek.gui.dialogEinstellungen.allgemein.ModernSearchConfigPanel;
import mediathek.gui.dialogEinstellungen.allgemein.TextFieldConfigWriter;
import mediathek.gui.dialogEinstellungen.allgemein.TimedDocumentListener;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TrayIconEvent;
import mediathek.gui.messages.UpdateStateChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXTitledPanel;

public class PanelEinstellungen
extends JPanel {
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private static final String NO_INFLUENCE_TEXT = "Einstellung hat unter macOS keine Auswirkung";
    private JCheckBox jCheckBoxTabsTop;
    private JCheckBox jCheckBoxTabIcon;
    private JCheckBox cbAutomaticMenuTabSwitching;
    private JCheckBox cbRestoreSelectedTab;
    private JTextField jtfUserAgent;
    private JTextField jtfProxyHost;
    private JTextField jtfProxyPort;
    private JTextField jtfProxyUser;
    private JPasswordField jpfProxyPassword;
    private JCheckBox jCheckBoxTray;
    private JCheckBox cbShowBlacklistIconWithText;
    private JCheckBox cbUseWikipediaSenderLogos;
    private JCheckBox cbAutomaticUpdateChecks;
    private JCheckBox cbDrawListIconsRight;
    private JCheckBox cbUseSystemDarkMode;
    private JXTitledPanel modernSearchTitlePanel;

    private void setupProxySettings() {
        this.jtfProxyHost.setText(this.config.getString("http.proxy.hostname", ""));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfProxyHost, "http.proxy.hostname");
        this.jtfProxyHost.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyPort.setText(this.config.getString("http.proxy.port", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyPort, "http.proxy.port");
        this.jtfProxyPort.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyUser.setText(this.config.getString("http.proxy.user", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyUser, "http.proxy.user");
        this.jtfProxyUser.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jpfProxyPassword.setText(this.config.getString("http.proxy.password", ""));
        listener = new TextFieldConfigWriter(this.jpfProxyPassword, "http.proxy.password");
        this.jpfProxyPassword.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void setupUserAgentSettings() {
        this.jtfUserAgent.setText(ApplicationConfiguration.getConfiguration().getString("application.user_agent"));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfUserAgent, "application.user_agent");
        this.jtfUserAgent.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void cbUseWikipediaSenderLogosActionPerformed(ActionEvent evt) {
        ApplicationConfiguration.getConfiguration().setProperty("application.sender_icons.use_local", (Object)(!this.cbUseWikipediaSenderLogos.isSelected() ? 1 : 0));
        MessageBus.getMessageBus().publishAsync((Object)new SenderIconStyleChangedEvent());
    }

    private void cbAutomaticUpdateChecksActionPerformed(ActionEvent evt) {
        ApplicationConfiguration.getConfiguration().setProperty("application.automatic_update_check", (Object)this.cbAutomaticUpdateChecks.isSelected());
        MessageBus.getMessageBus().publishAsync((Object)new UpdateStateChangedEvent(this.cbAutomaticUpdateChecks.isSelected()));
    }

    private void setupTabUI() {
        boolean tabPositionTop = this.config.getBoolean("application.ui.tab_position.top", true);
        this.jCheckBoxTabsTop.setSelected(tabPositionTop);
        this.jCheckBoxTabsTop.addActionListener(ae -> {
            this.config.setProperty("application.ui.tab_position.top", (Object)this.jCheckBoxTabsTop.isSelected());
            MessageBus.getMessageBus().publishAsync((Object)new TabVisualSettingsChangedEvent());
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.jCheckBoxTabsTop.setEnabled(false);
            this.jCheckBoxTabsTop.setToolTipText(NO_INFLUENCE_TEXT);
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxTabIcon.setSelected(config.getBoolean("application.ui.mainwindow.tab_icons", false));
        this.jCheckBoxTabIcon.addActionListener(ae -> {
            config.setProperty("application.ui.mainwindow.tab_icons", (Object)this.jCheckBoxTabIcon.isSelected());
            MessageBus.getMessageBus().publishAsync((Object)new TabVisualSettingsChangedEvent());
        });
    }

    @Handler
    private void handleTrayIconEvent(TrayIconEvent e) {
        SwingUtilities.invokeLater(() -> this.jCheckBoxTray.setSelected(this.config.getBoolean("application.ui.tray.use", false)));
    }

    private void setupTray() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.jCheckBoxTray.setSelected(false);
            this.jCheckBoxTray.setEnabled(false);
        } else {
            MessageBus.getMessageBus().subscribe((Object)this);
            this.jCheckBoxTray.setSelected(this.config.getBoolean("application.ui.tray.use", false));
            this.jCheckBoxTray.addActionListener(ae -> {
                this.config.setProperty("application.ui.tray.use", (Object)this.jCheckBoxTray.isSelected());
                MediathekGui.ui().initializeSystemTray();
            });
        }
    }

    private void setupModernSearch() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean useModernSearch = config.getBoolean("application.use.modern_search", false);
        ModernSearchConfigPanel searchPanel = new ModernSearchConfigPanel();
        searchPanel.getCbActivateModernSearch().setSelected(useModernSearch);
        searchPanel.getCbActivateModernSearch().addActionListener(l -> {
            boolean selected = searchPanel.getCbActivateModernSearch().isSelected();
            config.setProperty("application.use.modern_search", (Object)selected);
        });
        this.modernSearchTitlePanel.setContentContainer((Container)searchPanel);
    }

    public PanelEinstellungen() {
        this.initComponents();
        this.setupModernSearch();
        this.setupUserAgentSettings();
        this.setupProxySettings();
        this.setupTabUI();
        this.setupTray();
        this.setupTabSwitchListener();
        this.cbUseWikipediaSenderLogos.addActionListener(this::cbUseWikipediaSenderLogosActionPerformed);
        boolean useLocalSenderLogos = ApplicationConfiguration.getConfiguration().getBoolean("application.sender_icons.use_local", false);
        this.cbUseWikipediaSenderLogos.setSelected(!useLocalSenderLogos);
        this.cbAutomaticUpdateChecks.addActionListener(this::cbAutomaticUpdateChecksActionPerformed);
        this.cbAutomaticUpdateChecks.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("application.automatic_update_check", true));
        if (GuiFunktionen.isUsingExternalUpdater()) {
            this.cbAutomaticUpdateChecks.setEnabled(false);
            this.cbAutomaticUpdateChecks.setToolTipText("Diese Option ist deaktiviert, da ein externer Updater verwendet wird.");
        }
        boolean restore = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.restore_selected_tab", false);
        this.cbRestoreSelectedTab.setSelected(restore);
        this.cbRestoreSelectedTab.addActionListener(l -> ApplicationConfiguration.getConfiguration().setProperty("application.ui.restore_selected_tab", (Object)this.cbRestoreSelectedTab.isSelected()));
        boolean drawIconsRight = ApplicationConfiguration.getConfiguration().getBoolean("ui.list.iconposition_right", false);
        this.cbDrawListIconsRight.setSelected(drawIconsRight);
        this.cbDrawListIconsRight.addActionListener(l -> {
            ApplicationConfiguration.getConfiguration().setProperty("ui.list.iconposition_right", (Object)this.cbDrawListIconsRight.isSelected());
            MediathekGui.ui().repaint();
        });
        boolean useIconWithText = ApplicationConfiguration.getConfiguration().getBoolean("toolbar.blacklist_icon.text", false);
        this.cbShowBlacklistIconWithText.setSelected(useIconWithText);
        this.cbShowBlacklistIconWithText.addActionListener(l -> {
            boolean useText = this.cbShowBlacklistIconWithText.isSelected();
            ApplicationConfiguration.getConfiguration().setProperty("toolbar.blacklist_icon.text", (Object)useText);
        });
        boolean useSystemDarkMode = ApplicationConfiguration.getConfiguration().getBoolean("application.use_system_dark_mode", false);
        this.cbUseSystemDarkMode.setSelected(useSystemDarkMode);
        this.cbUseSystemDarkMode.addActionListener(l -> ApplicationConfiguration.getConfiguration().setProperty("application.use_system_dark_mode", (Object)this.cbUseSystemDarkMode.isSelected()));
    }

    private void setupTabSwitchListener() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cbAutomaticMenuTabSwitching.setEnabled(false);
            this.cbAutomaticMenuTabSwitching.setToolTipText(NO_INFLUENCE_TEXT);
            this.config.setProperty("application.ui.install_tab_listeners", (Object)false);
        } else {
            boolean installed;
            try {
                installed = this.config.getBoolean("application.ui.install_tab_listeners");
            }
            catch (NoSuchElementException ex) {
                installed = true;
                this.config.setProperty("application.ui.install_tab_listeners", (Object)true);
            }
            this.cbAutomaticMenuTabSwitching.setSelected(installed);
            this.cbAutomaticMenuTabSwitching.addActionListener(e -> {
                boolean isOn = this.cbAutomaticMenuTabSwitching.isSelected();
                this.config.setProperty("application.ui.install_tab_listeners", (Object)isOn);
                InstallTabSwitchListenerEvent evt = new InstallTabSwitchListenerEvent();
                evt.event = isOn ? InstallTabSwitchListenerEvent.INSTALL_TYPE.INSTALL : InstallTabSwitchListenerEvent.INSTALL_TYPE.REMOVE;
                MessageBus.getMessageBus().publishAsync((Object)evt);
            });
        }
    }

    private void initComponents() {
        JPanel jPanel5 = new JPanel();
        this.jCheckBoxTabsTop = new JCheckBox();
        this.jCheckBoxTabIcon = new JCheckBox();
        this.cbAutomaticMenuTabSwitching = new JCheckBox();
        this.cbRestoreSelectedTab = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jtfUserAgent = new JTextField();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.jtfProxyHost = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.jtfProxyPort = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.jtfProxyUser = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.jpfProxyPassword = new JPasswordField();
        JPanel panel1 = new JPanel();
        this.jCheckBoxTray = new JCheckBox();
        this.cbShowBlacklistIconWithText = new JCheckBox();
        this.cbUseWikipediaSenderLogos = new JCheckBox();
        this.cbAutomaticUpdateChecks = new JCheckBox();
        this.cbDrawListIconsRight = new JCheckBox();
        this.cbUseSystemDarkMode = new JCheckBox();
        this.modernSearchTitlePanel = new JXTitledPanel();
        this.setMaximumSize(new Dimension(10, 10));
        jPanel5.setBorder(new TitledBorder("Tab-Verhalten"));
        jPanel5.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill().gap().fill(), new AC().gap().fill()));
        this.jCheckBoxTabsTop.setText("Tabs oben anzeigen");
        jPanel5.add((Component)this.jCheckBoxTabsTop, new CC().cell(new int[]{0, 0}));
        this.jCheckBoxTabIcon.setText("Icons anzeigen");
        this.jCheckBoxTabIcon.setToolTipText("Im Tab keine Icons anzeigen");
        jPanel5.add((Component)this.jCheckBoxTabIcon, new CC().cell(new int[]{1, 0}));
        this.cbAutomaticMenuTabSwitching.setText("Tabs schalten automatisch bei Men\u00fcnutzung um");
        jPanel5.add((Component)this.cbAutomaticMenuTabSwitching, new CC().cell(new int[]{2, 0}));
        this.cbRestoreSelectedTab.setText("Letzte Auswahl beim Start wiederherstellen");
        this.cbRestoreSelectedTab.setToolTipText("Wenn gew\u00e4hlt wird beim Start des Programms automatisch das zuletzt genutzte Tab aktiviert.");
        jPanel5.add((Component)this.cbRestoreSelectedTab, new CC().cell(new int[]{0, 1, 3, 1}));
        jPanel3.setBorder(new TitledBorder("Download"));
        jLabel3.setText("User-Agent:");
        this.jtfUserAgent.setMinimumSize(new Dimension(200, 26));
        this.jtfUserAgent.setPreferredSize(new Dimension(520, 26));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(jLabel3).addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel3)).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2)));
        jPanel4.setBorder(new TitledBorder("HTTP-Proxy (Neustart erforderlich!)"));
        jPanel4.setToolTipText("");
        jLabel4.setText("Host:");
        jLabel5.setText("Port:");
        jLabel7.setText("User:");
        jLabel8.setText("Passwort:");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyHost, -2, 250, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyUser))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel8).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jtfProxyPort, -2, 72, -2).addGap(0, 187, Short.MAX_VALUE)).addComponent(this.jpfProxyPassword)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.jtfProxyHost, -2, -1, -2).addComponent(jLabel5).addComponent(this.jtfProxyPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.jtfProxyUser, -2, -1, -2).addComponent(jLabel8).addComponent(this.jpfProxyPassword, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panel1.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "0"), new AC().grow().align("left").gap().fill(), new AC().fill().gap().fill().gap().fill().gap().gap().fill()));
        this.jCheckBoxTray.setText("Programm ins Tray minimieren");
        panel1.add((Component)this.jCheckBoxTray, new CC().cell(new int[]{0, 0}));
        this.cbShowBlacklistIconWithText.setText("Blacklist-Filter-Icon mit Text anzeigen");
        this.cbShowBlacklistIconWithText.setToolTipText("Neustart erforderlich");
        panel1.add((Component)this.cbShowBlacklistIconWithText, new CC().cell(new int[]{1, 0}));
        this.cbUseWikipediaSenderLogos.setText("Senderlogos von Wikipedia verwenden");
        panel1.add((Component)this.cbUseWikipediaSenderLogos, new CC().cell(new int[]{0, 1}));
        this.cbAutomaticUpdateChecks.setText("Programmupdates t\u00e4glich suchen");
        panel1.add((Component)this.cbAutomaticUpdateChecks, new CC().cell(new int[]{0, 2}));
        this.cbDrawListIconsRight.setText("Info-Icons der Listen rechts darstellen");
        panel1.add((Component)this.cbDrawListIconsRight, new CC().cell(new int[]{0, 3}));
        this.cbUseSystemDarkMode.setText("Erscheinungsbild des Betriebssystem verwenden");
        this.cbUseSystemDarkMode.setToolTipText("Stellt den Hell-/Dunkelmodus der App beim Programmstart nach den aktuellen Einstellungen des Betriebssystem ein.");
        panel1.add((Component)this.cbUseSystemDarkMode, new CC().cell(new int[]{0, 4, 2, 1}));
        this.modernSearchTitlePanel.setTitle("Moderne Suche");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addComponent(jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(jPanel4, -2, -1, -2).addComponent(panel1, -2, -1, -2)).addGap(0, 20, Short.MAX_VALUE)).addComponent((Component)this.modernSearchTitlePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.modernSearchTitlePanel, -1, 122, Short.MAX_VALUE).addContainerGap()));
    }
}

