/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import sun.awt.AppContext;

abstract class Effect {
    Effect() {
    }

    abstract EffectType getEffectType();

    abstract float getOpacity();

    abstract BufferedImage applyEffect(BufferedImage var1, BufferedImage var2, int var3, int var4);

    protected static ArrayCache getArrayCache() {
        ArrayCache arrayCache = (ArrayCache)AppContext.getAppContext().get(ArrayCache.class);
        if (arrayCache == null) {
            arrayCache = new ArrayCache();
            AppContext.getAppContext().put(ArrayCache.class, arrayCache);
        }
        return arrayCache;
    }

    protected static class ArrayCache {
        private SoftReference<int[]> tmpIntArray = null;
        private SoftReference<byte[]> tmpByteArray1 = null;
        private SoftReference<byte[]> tmpByteArray2 = null;
        private SoftReference<byte[]> tmpByteArray3 = null;

        protected ArrayCache() {
        }

        protected int[] getTmpIntArray(int n) {
            int[] nArray;
            if (this.tmpIntArray == null || (nArray = this.tmpIntArray.get()) == null || nArray.length < n) {
                nArray = new int[n];
                this.tmpIntArray = new SoftReference<int[]>(nArray);
            }
            return nArray;
        }

        protected byte[] getTmpByteArray1(int n) {
            byte[] byArray;
            if (this.tmpByteArray1 == null || (byArray = this.tmpByteArray1.get()) == null || byArray.length < n) {
                byArray = new byte[n];
                this.tmpByteArray1 = new SoftReference<byte[]>(byArray);
            }
            return byArray;
        }

        protected byte[] getTmpByteArray2(int n) {
            byte[] byArray;
            if (this.tmpByteArray2 == null || (byArray = this.tmpByteArray2.get()) == null || byArray.length < n) {
                byArray = new byte[n];
                this.tmpByteArray2 = new SoftReference<byte[]>(byArray);
            }
            return byArray;
        }

        protected byte[] getTmpByteArray3(int n) {
            byte[] byArray;
            if (this.tmpByteArray3 == null || (byArray = this.tmpByteArray3.get()) == null || byArray.length < n) {
                byArray = new byte[n];
                this.tmpByteArray3 = new SoftReference<byte[]>(byArray);
            }
            return byArray;
        }
    }

    static enum EffectType {
        UNDER,
        BLENDED,
        OVER;

    }
}

