\name{MultiLabelSTAPLEImageFilter}
\alias{MultiLabelSTAPLEImageFilter}
\title{MultiLabelSTAPLEImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter performs a pixelwise combination of an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).
MultiLabelSTAPLEImageFilter}
\details{
The labelings in the images are weighted relative to each other based
on their "performance" as estimated by an expectation-maximization
algorithm. In the process, a ground truth segmentation is estimated,
and the estimated performances of the individual segmentations are
relative to this estimated ground truth.
The algorithm is based on the binary STAPLE algorithm by Warfield et
al. as published originally in
S. Warfield, K. Zou, W. Wells, "Validation of image segmentation and
expert quality with an expectation-maximization algorithm" in MICCAI
2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag,
Heidelberg, Germany, 2002, pp. 298-306
The multi-label algorithm implemented here is described in detail in
T. Rohlfing, D. B. Russakoff, and C. R. Maurer, Jr., "Performance-
based classifier combination in atlas-based image segmentation using
expectation-maximization parameter estimation," IEEE Transactions on
Medical Imaging, vol. 23, pp. 983-994, Aug. 2004.
INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.
The filter can optionally be provided with estimates for the a priori
class probabilities through the SetPriorProbabilities function. If no
estimate is provided, one is automatically generated by analyzing the
relative frequencies of the labels in the input images.
OUTPUTS
The filter produces a single output volume. Each output pixel contains
the label that has the highest probability of being the correct label,
based on the performance models of the individual segmentations. If
the maximum probability is not unique, i.e., if more than one label
have a maximum probability, then an "undecided" label is assigned to
that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.
In addition to the combined image, the estimated confusion matrices
for each of the input segmentations can be obtained through the
GetConfusionMatrix member function.
PARAMETERS
The label used for "undecided" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.
 A termination threshold for the EM iteration can be defined by
calling SetTerminationUpdateThreshold. The iteration terminates once
no single parameter of any confusion matrix changes by less than this
threshold. Alternatively, a maximum number of iterations can be
specified by calling SetMaximumNumberOfIterations. The algorithm may
still terminate after a smaller number of iterations if the
termination threshold criterion is satisfied.
EVENTS
This filter invokes IterationEvent() at each iteration of the E-M
algorithm. Setting the AbortGenerateData() flag will cause the
algorithm to halt after the current iteration and produce results just
as if it had converged. The algorithm makes no attempt to report its
progress since the number of iterations needed cannot be known in
advance.
Torsten Rohlfing, SRI International, Neuroscience Program
See:
MultiLabelSTAPLE for the procedural interface
MultiLabelSTAPLEImageFilter}
%C++ includes: sitkMultiLabelSTAPLEImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{std::vector< float > GetConfusionMatrix(unsigned int input) const:}{
Get confusion matrix for the i-th input segmentation.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint64_t GetLabelForUndecidedPixels() const:}{
     Get label value used for undecided pixels.
After updating the filter, this function returns the actual label
value used for undecided pixels in the current output. Note that this
value is overwritten when SetLabelForUndecidedPixels is called and the
new value only becomes effective upon the next filter update.
}
\item{unsigned int GetMaximumNumberOfIterations() const:}{
Set maximum number of iterations.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< float > GetPriorProbabilities() const:}{
     Get prior class probabilities.
After updating the filter, this function returns the actual prior
class probabilities. If these were not previously set by a call to
SetPriorProbabilities, then they are estimated from the input
segmentations and the result is available through this function.
}
\item{float GetTerminationUpdateThreshold() const:}{
Set termination threshold based on confusion matrix parameter updates.
}
\item{ MultiLabelSTAPLEImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels):}{
Set label value for undecided pixels.
}
\item{Self SetMaximumNumberOfIterations(unsigned int MaximumNumberOfIterations):}{
Set maximum number of iterations.
}
\item{Self SetPriorProbabilities(std::vector< float > PriorProbabilities):}{
     Set manual estimates for the a priori class probabilities. The
size of the array must be greater than the value of the largest label. The index into the array corresponds to the label
value in the segmented image for the class.
}
\item{Self SetTerminationUpdateThreshold(float TerminationUpdateThreshold):}{
Set termination threshold based on confusion matrix parameter updates.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MultiLabelSTAPLEImageFilter():}{
Destructor
}
}
}
