\name{LabelOverlayImageFilter}
\alias{LabelOverlayImageFilter}
\title{LabelOverlayImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Apply a colormap to a label image and put it on top of the input
image.
LabelOverlayImageFilter}
\details{
Apply a colormap to a label image and put it on top of the input
image. The set of colors is a good selection of distinct colors. The
opacity of the label image can be defined by the user. The user can
also choose if the want to use a background and which label value is
the background. A background label produce a gray pixel with the same
intensity than the input one.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This class was contributed to the Insight Journal https://www.insight-journal.org/browse/publication/79
See:
LabelToRGBImageFilter
LabelMapOverlayImageFilter , LabelOverlayFunctor
LabelOverlay for the procedural interface
itk::LabelOverlayImageFilter for the Doxygen on the original ITK class.
LabelOverlayImageFilter}
%C++ includes: sitkLabelOverlayImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &labelImage):}{}
\item{Image Execute(Image &&image, const Image &labelImage):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the background value.
}
\item{std::vector< uint8_t > GetColormap() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOpacity() const:}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1.
}
\item{ LabelOverlayImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the background value.
}
\item{Self SetColormap(std::vector< uint8_t > Colormap):}{}
\item{Self SetOpacity(double Opacity):}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelOverlayImageFilter():}{
Destructor
}
}
}
