/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;

public class TermsAggregationEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final ImmutableSet<String> READ_ACTIONS = ImmutableSet.of((Object)"indices:data/read/msearch", (Object)"indices:data/read/mget", (Object)"indices:data/read/get", (Object)"indices:data/read/search", (Object)"indices:data/read/field_caps");
    private static final QueryBuilder NONE_QUERY = new MatchNoneQueryBuilder();

    public PrivilegesEvaluatorResponse evaluate(IndexResolverReplacer.Resolved resolved, ActionRequest request, PrivilegesEvaluationContext context, ActionPrivileges actionPrivileges, PrivilegesEvaluatorResponse presponse) {
        try {
            AggregationBuilder ab;
            SearchRequest sr;
            if (request instanceof SearchRequest && (sr = (SearchRequest)request).source() != null && sr.source().query() == null && sr.source().aggregations() != null && sr.source().aggregations().getAggregatorFactories() != null && sr.source().aggregations().getAggregatorFactories().size() == 1 && sr.source().size() == 0 && (ab = (AggregationBuilder)sr.source().aggregations().getAggregatorFactories().iterator().next()) instanceof TermsAggregationBuilder && "terms".equals(ab.getType()) && "indices".equals(ab.getName()) && "_index".equals(((TermsAggregationBuilder)ab).field()) && ab.getPipelineAggregations().isEmpty() && ab.getSubAggregations().isEmpty()) {
                PrivilegesEvaluatorResponse subResponse = actionPrivileges.hasIndexPrivilege(context, (Set<String>)READ_ACTIONS, IndexResolverReplacer.Resolved._LOCAL_ALL);
                if (subResponse.isPartiallyOk()) {
                    sr.source().query((QueryBuilder)new TermsQueryBuilder("_index", (Iterable)Sets.union(subResponse.getAvailableIndices(), resolved.getRemoteIndices())));
                } else if (!subResponse.isAllowed()) {
                    sr.source().query(NONE_QUERY);
                }
                presponse.allowed = true;
                return presponse.markComplete();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to evaluate terms aggregation", (Throwable)e);
            return presponse;
        }
        return presponse;
    }
}

