/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public abstract class BaseHttpServletRequestXMLMessageDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseHttpServletRequestXMLMessageDecoder.class);
    @NonnullAfterInit
    private ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();

    @Override
    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpServletRequest");
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new MessageDecodingException("HttpServletRequest was null");
        }
        this.log.debug("HttpServletRequest indicated Content-Type: {}", (Object)request.getContentType());
        this.validateHttpRequest(request);
        super.decode();
        this.log.debug("Successfully decoded message from HttpServletRequest.");
    }

    @NonnullAfterInit
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        this.checkSetterPreconditions();
        this.parserPool = Constraint.isNotNull(pool, "ParserPool cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    @Override
    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message == null || !XMLObject.class.isInstance(message)) {
            this.log.debug("Message was null or unsupported, can not serialize");
            return null;
        }
        try {
            Element dom = XMLObjectSupport.marshall((XMLObject)XMLObject.class.cast(message));
            return SerializeSupport.prettyPrintXML(dom);
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            return null;
        }
    }

    protected XMLObject unmarshallMessage(@Nonnull InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream(this.getParserPool(), messageStream);
            return message;
        }
        catch (XMLParserException e) {
            this.log.error("Error unmarshalling message from input stream: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error unmarshalling message from input stream", e);
        }
        catch (UnmarshallingException e) {
            this.log.error("Error unmarshalling message from input stream: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error unmarshalling message from input stream", e);
        }
    }

    protected void validateHttpRequest(@Nonnull HttpServletRequest request) throws MessageDecodingException {
    }
}

