/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class LegacyHSQLLimitHandler
extends AbstractSimpleLimitHandler {
    public static LegacyHSQLLimitHandler INSTANCE = new LegacyHSQLLimitHandler();

    protected String limitClause(boolean hasFirstRow) {
        return hasFirstRow ? " limit ? ?" : " top ?";
    }

    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(1, null);
        if (hasFirstRow) {
            return " limit 1+" + firstParameter + " " + parameterMarkerStrategy.createMarker(2, null);
        }
        return " top " + firstParameter;
    }

    protected String insert(String limitOrTop, String sql) {
        return LegacyHSQLLimitHandler.insertAfterSelect((String)limitOrTop, (String)sql);
    }

    public final boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean processSqlMutatesState() {
        return false;
    }

    public int getParameterPositionStart(Limit limit) {
        return LegacyHSQLLimitHandler.hasMaxRows((Limit)limit) ? (LegacyHSQLLimitHandler.hasFirstRow((Limit)limit) ? 3 : 2) : (LegacyHSQLLimitHandler.hasFirstRow((Limit)limit) ? 2 : 1);
    }
}

