/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter computes the stochastic fractal dimension of the input
image.


The methodology is based on Mandelbrot's fractal theory and the
concept of fractional Brownian motion and yields images which have
been used for classification and edge enhancement.

This class which is templated over the input and output images as well
as a mask image type. The input is a scalar image, an optional
neighborhood radius (default = 2), and an optional mask. The mask can
be specified to decrease computation time since, as the authors point
out, calculation is time-consuming.

This filter was contributed by Nick Tustison and James Gee from the
PICSL lab, at the University of Pennsylvania as an paper to the
Insight Journal:

"Stochastic Fractal Dimension Image" https://doi.org/10.54294/ne109t


Nick Tustison

See:
 itk::simple::StochasticFractalDimension for the procedural interface

 itk::StochasticFractalDimensionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkStochasticFractalDimensionImageFilter.h
*/
public class StochasticFractalDimensionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected StochasticFractalDimensionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.StochasticFractalDimensionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(StochasticFractalDimensionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(StochasticFractalDimensionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::StochasticFractalDimensionImageFilter::~StochasticFractalDimensionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_StochasticFractalDimensionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::StochasticFractalDimensionImageFilter::StochasticFractalDimensionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  StochasticFractalDimensionImageFilter() {
    this(SimpleITKJNI.new_StochasticFractalDimensionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::StochasticFractalDimensionImageFilter::SetNeighborhoodRadius(unsigned int value)

Set the values of the NeighborhoodRadius vector all to value

*/
public  void setNeighborhoodRadius(VectorUInt32 NeighborhoodRadius) {
    SimpleITKJNI.StochasticFractalDimensionImageFilter_setNeighborhoodRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(NeighborhoodRadius), NeighborhoodRadius);
  }

  /**
Self&amp; itk::simple::StochasticFractalDimensionImageFilter::SetNeighborhoodRadius(unsigned int value)

Set the values of the NeighborhoodRadius vector all to value

*/
public  void setNeighborhoodRadius(long value) {
    SimpleITKJNI.StochasticFractalDimensionImageFilter_setNeighborhoodRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::StochasticFractalDimensionImageFilter::GetNeighborhoodRadius() const

Manhattan radius used for evaluating the fractal dimension.

*/
public  VectorUInt32 getNeighborhoodRadius() {
    return new VectorUInt32(SimpleITKJNI.StochasticFractalDimensionImageFilter_getNeighborhoodRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::StochasticFractalDimensionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.StochasticFractalDimensionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::StochasticFractalDimensionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.StochasticFractalDimensionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::StochasticFractalDimensionImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.StochasticFractalDimensionImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::StochasticFractalDimensionImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.StochasticFractalDimensionImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
