<?php

declare(strict_types=1);

namespace Drupal\KernelTests\Core\Http;

use Drupal\KernelTests\KernelTestBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Tests the headers added by BinaryFileResponse.
 *
 * @group Http
 */
class BinaryFileResponseTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['binary_file_response_test'];

  /**
   * Test the content type generated by Drupal is correct.
   *
   * @dataProvider providerTestCalculatedContentType
   */
  public function testCalculatedContentType($path, $content_type): void {
    $query = ['relative_file_url' => $path];
    $request = Request::create('/binary_file_response_test/download', 'GET', $query);

    $response = \Drupal::service('http_kernel')->handle($request);
    $response->prepare($request);

    $this->assertSame($content_type, current(explode(';', $response->headers->get('Content-Type'))));
  }

  /**
   * Data provider of file names and expected content-type values.
   */
  public static function providerTestCalculatedContentType(): array {
    return [
      ['core/misc/print.css', 'text/css'],
      ['core/misc/checkbox.js', 'text/javascript'],
      ['core/misc/tree.png', 'image/png'],
    ];
  }

}
