/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Set;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterChain
implements FilterChain {
    private static final ThreadLocal<ServletRequest> lastServicedRequest = new ThreadLocal();
    private static final ThreadLocal<ServletResponse> lastServicedResponse = new ThreadLocal();
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private boolean servletSupportsAsync = false;
    private boolean dispatcherWrapsSameObject = false;
    private static final StringManager sm = StringManager.getManager(ApplicationFilterChain.class);
    private static final Class<?>[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
    private static final Class<?>[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            ServletRequest servletRequest2 = servletRequest;
            ServletResponse servletResponse2 = servletResponse;
            try {
                AccessController.doPrivileged(() -> {
                    this.internalDoFilter(servletRequest2, servletResponse2);
                    return null;
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.internalDoFilter(servletRequest, servletResponse);
        }
    }

    private void internalDoFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[this.pos++];
            try {
                Filter filter = applicationFilterConfig.getFilter();
                if (servletRequest.isAsyncSupported() && !applicationFilterConfig.getFilterDef().getAsyncSupportedBoolean()) {
                    servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
                }
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest servletRequest2 = servletRequest;
                    ServletResponse servletResponse2 = servletResponse;
                    Principal principal = ((HttpServletRequest)servletRequest2).getUserPrincipal();
                    Object[] objectArray = new Object[]{servletRequest2, servletResponse2, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, objectArray, principal);
                } else {
                    filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                }
            }
            catch (ServletException | IOException | RuntimeException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                throw new ServletException(sm.getString("filterChain.filter"), throwable2);
            }
            return;
        }
        try {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(servletRequest);
                lastServicedResponse.set(servletResponse);
            }
            if (servletRequest.isAsyncSupported() && !this.servletSupportsAsync) {
                servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
            }
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse && Globals.IS_SECURITY_ENABLED) {
                ServletRequest servletRequest3 = servletRequest;
                ServletResponse servletResponse3 = servletResponse;
                Principal principal = ((HttpServletRequest)servletRequest3).getUserPrincipal();
                Object[] objectArray = new Object[]{servletRequest3, servletResponse3};
                SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, objectArray, principal);
            } else {
                this.servlet.service(servletRequest, servletResponse);
            }
        }
        catch (ServletException | IOException | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable3);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable3);
        }
        finally {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return lastServicedResponse.get();
    }

    void addFilter(ApplicationFilterConfig applicationFilterConfig) {
        for (int i = 0; i < this.n; ++i) {
            if (this.filters[i] != applicationFilterConfig) continue;
            return;
        }
        if (this.n == this.filters.length) {
            this.filters = Arrays.copyOf(this.filters, this.n + 10);
        }
        this.filters[this.n++] = applicationFilterConfig;
    }

    void release() {
        for (int i = 0; i < this.n; ++i) {
            this.filters[i] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.servletSupportsAsync = false;
        this.dispatcherWrapsSameObject = false;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setServletSupportsAsync(boolean bl) {
        this.servletSupportsAsync = bl;
    }

    void setDispatcherWrapsSameObject(boolean bl) {
        this.dispatcherWrapsSameObject = bl;
    }

    public void findNonAsyncFilters(Set<String> set) {
        for (int i = 0; i < this.n; ++i) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[i];
            if (applicationFilterConfig.getFilterDef().getAsyncSupportedBoolean()) continue;
            set.add(applicationFilterConfig.getFilterClass());
        }
    }
}

