/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import org.mvel2.ast.ASTNode;
import org.mvel2.ast.TypeCast;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;

public class ExecutableAccessor
implements ExecutableStatement {
    private ASTNode node;
    private Class ingress;
    private Class egress;
    private boolean convertable;

    public ExecutableAccessor(ASTNode node, Class egress) {
        this.node = node;
        this.egress = egress;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        return this.node.getReducedValueAccelerated(ctx, elCtx, variableFactory);
    }

    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        return this.node.getReducedValueAccelerated(staticContext, staticContext, factory);
    }

    @Override
    public void setKnownIngressType(Class type2) {
        this.ingress = type2;
    }

    @Override
    public void setKnownEgressType(Class type2) {
        this.egress = type2;
    }

    @Override
    public Class getKnownIngressType() {
        return this.ingress;
    }

    @Override
    public Class getKnownEgressType() {
        return this.egress;
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return this.convertable;
    }

    @Override
    public void computeTypeConversionRule() {
        if (this.ingress != null && this.egress != null) {
            this.convertable = this.ingress.isAssignableFrom(this.egress);
        }
    }

    @Override
    public boolean intOptimized() {
        return false;
    }

    public ASTNode getNode() {
        return this.node;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    @Override
    public boolean isLiteralOnly() {
        return false;
    }

    @Override
    public boolean isExplicitCast() {
        return this.node instanceof TypeCast;
    }

    @Override
    public boolean isEmptyStatement() {
        return this.node == null;
    }

    public String toString() {
        return this.node.toString();
    }
}

