#include "libresolve.h"

int
read_address (FILE *fp)
{ 
  char type[2], buf[150], address [10], symbol [64];
  int i;

  i = 0;  
  do {
    safe_gets (buf, sizeof (buf), fp);
    if (feof(fp))
      break;

    if (!buf [0]) continue; 

    sscanf (buf, "%s %s %s", address, type, symbol);
    if (strlen (address) < 8) {
       fprintf(stderr, "warning: address is to short %s\n", address);
       continue;
     }  

    switch (*type) {
    case 'T': case 'B': case 'A': case 'C': case 'D':
      if (i >= sizeoflib) {
        sizeoflib <<= 1;
        symoflib  = realloc (symoflib, sizeoflib * sizeof (def_symbol));
        if (!symoflib) {
	  fatal ("Virtual memory exhausted!\n");
        }
      }
      strcpy (symoflib [i].address, address);
      strcpy (symoflib [i].symbol, symbol);
      symoflib [i].type = type [0];
      i++;
    }

  } while (1);

  fclose (fp);
  if (!i)
     fatal ("No addresses are found!\n");
  return i;
}
