*** tilde.c	Sat Oct 10 13:56:38 1992
--- new/tilde.c	Tue Oct 27 21:53:22 1992
***************
*** 1,33 ****
  /* tilde.c -- Tilde expansion code (~/foo := $HOME/foo). */
  
! /* Copyright (C) 1988,1989 Free Software Foundation, Inc.
  
     This file is part of GNU Readline, a library for reading lines
     of text with interactive input and history editing.
  
!    Readline is free software; you can redistribute it and/or modify it
!    under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 1, or (at your option) any
!    later version.
! 
!    Readline is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!    General Public License for more details.
  
     You should have received a copy of the GNU General Public License
!    along with Readline; see the file COPYING.  If not, write to the Free
!    Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
  
! #if defined (__GNUC__)
! #  define alloca __builtin_alloca
! #else
! #  if (defined (sparc) && defined (sun)) || defined (HAVE_ALLOCA_H)
! #    include <alloca.h>
! #  endif
! #endif
  
  #include <pwd.h>
  
  #ifndef savestring
  #define savestring(x) (char *)strcpy (xmalloc (1 + strlen (x)), (x))
--- 1,34 ----
  /* tilde.c -- Tilde expansion code (~/foo := $HOME/foo). */
  
! /* Copyright (C) 1988,1989, 1991 Free Software Foundation, Inc.
  
     This file is part of GNU Readline, a library for reading lines
     of text with interactive input and history editing.
  
!    Readline is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation; either version 2 of the License, or
!    (at your option) any later version.
! 
!    Readline is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
  
     You should have received a copy of the GNU General Public License
!    along with this program; if not, write to the Free Software
!    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
  
! #include "sysdep.h"
  
+ #ifndef __MSDOS__
  #include <pwd.h>
+ #endif
+ 
+ #ifdef __GNUC__
+ #undef alloca
+ #define alloca(x) __builtin_alloca(x)
+ #endif
  
  #ifndef savestring
  #define savestring(x) (char *)strcpy (xmalloc (1 + strlen (x)), (x))
***************
*** 38,56 ****
  #  define NULL 0x0
  #endif
  
- #ifdef linux
- #include <stdlib.h>
- #include <strings.h>
- extern char *xmalloc (), *xrealloc ();
- #else
  #if defined (TEST)
  static char *xmalloc (), *xrealloc ();
  #else
! extern char *malloc (), *xrealloc ();
  #endif /* TEST */
  
- #endif
- #ifndef jump
  /* The default value of tilde_additional_prefixes.  This is set to
     whitespace preceding a tilde so that simple programs which do not
     perform any word separation get desired behaviour. */
--- 39,50 ----
  #  define NULL 0x0
  #endif
  
  #if defined (TEST)
  static char *xmalloc (), *xrealloc ();
  #else
! extern char *xmalloc (), *xrealloc ();
  #endif /* TEST */
  
  /* The default value of tilde_additional_prefixes.  This is set to
     whitespace preceding a tilde so that simple programs which do not
     perform any word separation get desired behaviour. */
***************
*** 78,88 ****
     the end of a username, instead of just "/".  Bash sets this to
     `:' and `=~'. */
  char **tilde_additional_suffixes = default_suffixes;
! #else
! extern Function *tilde_expansion_failure_hook;
! extern char **tilde_additional_prefixes;
! extern char **tilde_additional_suffixes;
! #endif
  /* Find the start of a tilde expansion in STRING, and return the index of
     the tilde which starts the expansion.  Place the length of the text
     which identified this tilde starter in LEN, excluding the tilde itself. */
--- 72,78 ----
     the end of a username, instead of just "/".  Bash sets this to
     `:' and `=~'. */
  char **tilde_additional_suffixes = default_suffixes;
! 
  /* Find the start of a tilde expansion in STRING, and return the index of
     the tilde which starts the expansion.  Place the length of the text
     which identified this tilde starter in LEN, excluding the tilde itself. */
***************
*** 164,171 ****
        start = tilde_find_prefix (filename, &len);
  
        /* Copy the skipped text into the result. */
!       if ((result_index + start + 1) > result_size)
! 	result = (char *)xrealloc (result, 1 + (result_size += (start + 20)));
  
        strncpy (result + result_index, filename, start);
        result_index += start;
--- 154,168 ----
        start = tilde_find_prefix (filename, &len);
  
        /* Copy the skipped text into the result. */
!       /* This test is always true the first time, since result_index
! 	 is 0, result_size is 0, and start is >= 0.  So we malloc here.  */
!       if ((result_index + start + 1) > result_size) {
! 	result_size += (start + 20);
! 	if (result == NULL)
! 	  result = (char *)xmalloc  (        1 + result_size);
! 	else
! 	  result = (char *)xrealloc (result, 1 + result_size);
!       }
  
        strncpy (result + result_index, filename, start);
        result_index += start;
***************
*** 231,237 ****
--- 228,236 ----
  	}
        else
  	{
+ #ifndef __MSDOS__
  	  struct passwd *getpwnam (), *user_entry;
+ #endif
  	  char *username = (char *)alloca (257);
  	  int i, c;
  
***************
*** 244,254 ****
--- 243,255 ----
  	    }
  	  username[i - 1] = '\0';
  
+ #ifndef __MSDOS__
  	  if (!(user_entry = getpwnam (username)))
  	    {
  	      /* If the calling program has a special syntax for
  		 expanding tildes, and we couldn't find a standard
  		 expansion, then let them try. */
+ #endif
  	      if (tilde_expansion_failure_hook)
  		{
  		  char *expansion;
***************
*** 267,272 ****
--- 268,274 ----
  		    }
  		}
  	      /* We shouldn't report errors. */
+ #ifndef __MSDOS__
  	    }
  	  else
  	    {
***************
*** 274,284 ****
--- 276,289 ----
  					  + strlen (&dirname[i]));
  	      strcpy (temp_name, user_entry->pw_dir);
  	      strcat (temp_name, &dirname[i]);
+ #endif
  	    return_name:
  	      free (dirname);
  	      dirname = savestring (temp_name);
+ #ifndef __MSDOS__
  	    }
  	    endpwent ();
+ #endif
  	}
      }
    return (dirname);
