#include "libresolve.h"

int
resolve_lib (FILE *fp)
{ 
  char buf[150];

  /* First is a blank line. */
  safe_gets (buf, sizeof(buf), fp);
  if (feof (fp))
    fatal ("The first line in address file must be blank!\n");
    
  /* name of the library. */
  safe_gets (buf, sizeof(buf), fp);
  if (feof (fp))
    fatal ("The second line in address file must be library name!\n");

  fprintf (stderr, "Resolving `%s'\n", buf);
    
  /* another blank line. */
  safe_gets (buf, sizeof(buf), fp);
  if (feof (fp))
    fatal ("The third line in address file must be blank!\n");

  do {
    /* resolve a module */
    int ret;
    ret = resolve_module (fp);
    if (ret == -1) return (0);
  } while (1);

  return 0;
}
