#include "libresolve.h"
#include <unistd.h>

static char *
find_indirect (char type, char *address)
{
  int i;

  for (i = 0; i < numofmodule; i++) {
    if (!strcmp (symofmodule [i].address, address))
      return symofmodule [i].symbol;
  }

  return NULL;
}

static int
resolve_symbol (char *address, char type, char *symbol, FILE *fp)
{
  int j;
  char *indirect;

  switch (type) {
  case 'T' : case 'B' : case 'D' : case 'C' : case 'I':
    /* Find a match. */
    for (j = 0; j < numoflib; j++)
      if (((symoflib [j].type == 'B' && type == 'C') ||
		(symoflib [j].type == 'D' && type == 'C') ||
		(symoflib [j].type == 'A' && type == 'T') ||
		(symoflib [j].type == 'A' && type == 'I') ||
		(symoflib [j].type == 'T' && type == 'I') ||
		(symoflib [j].type == type)) && 
		(!strcmp (symoflib [j].symbol, symbol)))
	break;  

    if (j >= numoflib) {
      fprintf(stderr, "Warning: no address found for symbol: %s\n", symbol);
      return (1);
    }
    fprintf (fp, "\t.globl\t%s\n\t%s = 0x%s\n", symbol, symbol, symoflib [j].address);
    break;
  case 'X':
    indirect = find_indirect (type, address);
    if (!indirect) {
      fprintf(stderr, "Warning: no indirect address found for symbol: %s\n", symbol);
      return (1);
    }
    fprintf (fp, ".stabs \"%s\",23,0,0,%s\n", symbol, indirect);
    break;
  case 'x':
    indirect = find_indirect (type, address);
    if (!indirect) {
      fprintf(stderr, "Warning: no indirect address found for symbol: %s\n", symbol);
      return (1);
    }
    fprintf (fp, ".stabs \"%s\",22,0,0,%s\n", symbol, indirect);
    break;
  case 'Z':
    indirect = find_indirect (type, address);
    if (!indirect) {
      fprintf(stderr, "Warning: no indirect address found for symbol: %s\n", symbol);
      return (1);
    }
    fprintf (fp, ".stabs \"%s\",25,0,0,%s\n", symbol, indirect);
    break;
  case 'z':
    indirect = find_indirect (type, address);
    if (!indirect) {
      fprintf(stderr, "Warning: no indirect address found for symbol: %s\n", symbol);
      return (1);
    }
    fprintf (fp, ".stabs \"%s\",24,0,0,%s\n", symbol, indirect);
    break;
  case 't': case 'c': case 'd': case 'b': case 'U':
    break;	/* ignored */
  case 'S': case 's': case 'L': case 'l':
    fprintf (stderr, "Unimplemented symbol type: address: %s, type: %c, name:%s\n",
    	address, type, symbol);
    return (1);
  default:
    fprintf (stderr, "Unknown symbol type: address: %s, type: %c, name:%s\n",
    	address, type, symbol);
    return (1);
  }

  return (0);
}

int
resolve_module (FILE *fp)
{ 
  char type[2], buf[150], symbol [64], address[10];
  char module [50];
  FILE *fp_module;
  int i;
  int len;
  int eof_seen = 0;
  int not_found = 1;

  /* name of the file. */
  safe_gets (module, sizeof(module), fp);
  if (feof (fp))
    fatal ("Expecting a module name in symbol file!\n");
    
  len = strlen (module) - 1;
  module [len] = 0;
  if (('o' == module [len - 1]) && ('.' == module [len - 2]))
    module [len - 1] = 's';
  else {
    fprintf (stderr, "Warning: non .o module %s\n", module);  
    fatal ("Module name expected!\n");
  }

  fprintf (stderr, "Making `%s'\n", module);

  /* read in all the symbols in the module. */
  i = 0;
  do
  {
    safe_gets (buf, sizeof(buf), fp);
    /* either a blank line or end of file. */
    if (feof (fp)) {
      eof_seen = 1;
      break;
    }

    if (!buf [0])
	break;

    if (buf [0] == '\t' || buf [0] == ' ')
       continue;

    sscanf(buf,"%s %s %s", address, type, symbol);

    if (i >= sizeofmodule) {
      sizeofmodule <<= 1;
      symofmodule = realloc (symofmodule, sizeofmodule * sizeof (def_symbol));
      if (!symofmodule)
	fatal ("Virtual memory exhausted!\n");
    }

    strcpy (symofmodule [i].address, address);
    strcpy (symofmodule [i].symbol, symbol);
    symofmodule [i].type = type [0];

    i++;
  } while (1);

  /* end of file */
  if (!i && eof_seen) return -1;

  /* nothing to do */
  if (!i) return (0);

  numofmodule = i;

  fp_module = fopen (module, "w");
  if (!fp_module) { 
    perror (prog);
    fprintf (stderr, "Can not open %s\n", module);
    exit (1);
  }

  if (symbol1 != NULL) {
    fprintf (fp_module, "\t.long\t_%s\n", symbol1);
  }
  if (symbol2 != NULL) {
    fprintf (fp_module, "\t.long\t_%s\n", symbol2);
  }
 
  for (i = 0; i < numofmodule; i++) {
    if (!resolve_symbol (symofmodule [i].address,
    	symofmodule [i].type, symofmodule [i].symbol, fp_module))
      not_found = 0;
  }

  fclose (fp_module);

  /* if nothing is found, just remove the files.*/
  if (not_found)
    unlink (module); 

  return (eof_seen) ? -1 : 1;
}
