#include "libresolve.h"

void
fatal (const char *str)
{
  fputs (prog, stderr);
  fputs (":", stderr);
  fputs (str, stderr);
  exit(1);
}

void
warning (const char *str)
{
  fputs (prog, stderr);
  fputs (":", stderr);
  fputs (str, stderr);
}

void
usage ()
{
  fprintf (stderr, "%s:\n\tUsage: %s -a address_file -s symbol_file -u symbol1 -U symbol2\n",
  	prog, prog);
  exit (1);
}

void
safe_gets (char *buf, int size, FILE *fp)
{
  int len;
  fgets (buf, size, fp);
  len = strlen(buf);
  if (len > 0)
    buf[len - 1] = '\0';
}
