#define MAIN
#include "libresolve.h"

int
main(int argc, char *argv[])
{ 
  int c;

  /* Name of the program. */
  prog = *argv;

  while ((c = getopt(argc, argv, "u:U:a:s:")) != EOF) {
    switch (c) {
    case 'a':
      if (!(address_file = fopen (optarg, "r"))) {
        perror (prog);
        fprintf (stderr, "%s: Can not open address file %s.\n", prog, optarg); 
        exit(1);
      }
      break;
    case 's':
      if (!(symbol_file = fopen (optarg, "r"))) {
        perror (prog);
        fprintf (stderr, "%s: Can not open symbol file %s.\n", prog, optarg); 
        exit(1);
      }
      break;
    case 'u':
      symbol1 = optarg;
      break;
    case 'U':
      symbol2 = optarg;
      break;
    default:
      usage ();
    }
  }
  
  if (!address_file || !symbol_file) {
     usage ();
  }

  symoflib = malloc (MAX_LIB * sizeof (def_symbol));
  symofmodule = malloc (MAX_MODULE * sizeof (def_symbol));
  if (!symoflib || ! symofmodule) {
    fatal ("Virtual memory exhausted!\n");
  }
  sizeoflib = MAX_LIB;
  sizeofmodule = MAX_MODULE;

  numoflib = read_address (address_file);

  resolve_lib (symbol_file);
}
