#ifndef _LIBRESOLVE_H
#define	_LIBRESOLVE_H

#include <stdio.h>
#include <string.h>
#ifdef linux
#include <getopt.h>
#else
extern int optind;
extern char *optarg;
#endif
#define NO_FIX_MALLOC
#include <stdlib.h>
#undef NO_FIX_MALLOC

#define MAX_LIB		2000
#define MAX_MODULE	200

typedef struct {
  char address [10];
  char type;
  char symbol [64];
} def_symbol;

#ifdef MAIN
#define EXTERN
FILE *address_file = NULL;
FILE *symbol_file = NULL;

char *symbol1 = NULL;
char *symbol2 = NULL;

#else

#define EXTERN	extern

extern FILE *address_file;
extern FILE *symbol_file;

extern char *symbol1;
extern char *symbol2;

#endif

EXTERN char *prog;

EXTERN def_symbol *symoflib;
EXTERN int sizeoflib;
EXTERN int numoflib;

EXTERN def_symbol *symofmodule;
EXTERN int sizeofmodule;
EXTERN int numofmodule;

extern int read_address (FILE *);
extern void usage ();
extern void fatal (const char *);
extern void warning (const char *);
extern void safe_gets (char *, int, FILE *);
extern int resolve_module (FILE *);
extern int resolve_lib (FILE *__fp);

#endif
