char *usagestr = 
"libresolve:  Resolve shared library addresses into their static modules."
"\n"
"  usage:\n"
"\n"
"	mkdir tmp\n"
"	cd tmp\n"
"	nm /usr/lib/libc.a.static > nmstatic\n"
"	nm /lib/library/libx.y.z > nmshared\n"
"	libresolve [-u symbol1] [-U symbol2] nmshared < nmstatic\n"
"	gcc -c *.s\n"
"	gar -r libc.a *.o\n";
	
#define _UNSHARED_STDIO

#include <stdio.h>
#include <string.h>
#ifdef linux
#include <getopt.h>
#else
extern int optind;
extern char *optarg;
#endif

#define MAX 10000

struct {
	char address[10];
	char type;
	char entry[64];
} shars[MAX];	

void error(char *str)
{  puts(str);
   exit(1);
}

int main(int argc, char *argv[])
{ 
  char type[100], buf[200], module[200], entry[64], address[10];
  char jumpbuf [100];
  FILE *F = NULL;
  int i, j, numshars;
  int c, DoLibc = 0;
  char *symbol1 = NULL;
  char *symbol2 = NULL;
  int jump = 0;

  while ((c = getopt(argc, argv, "ju:U:")) != EOF)
  {
    switch (c)
    {
      case 'j':
	jump = 1;
        break;
      case 'u':
        symbol1 = optarg;
        break;
      case 'U':
        symbol2 = optarg;
        break;
      default:
        exit(1);
    }
  }
  
  if (optind + 1 != argc)
  { 
  	printf(usagestr);
  	/*"usage: libresolve nm_libshared < nm_libc \n");*/
  	exit(1);
  }

  if (!(F=fopen(argv[optind],"r")))
  { printf("can not open file %s with nm output from shared lib\n", argv[1]); 
    exit(1);
  }
  /* First get the shared lib names. */  
  i = 0;  
  do
  {
    fgets(buf,sizeof(buf),F);
    if (feof(F))
      break;
    j = strlen(buf);
    if (j>0)
      buf[j-1] = '\0';
    
    if (!buf[0])  
    { break;
    }
    else
      {
        sscanf(buf,"%s %s %s", address, type, entry );
        if (strlen(address)<8)
        { printf("warning: address is to short %s\n", address);
          continue;
        }  
        if (('T' == *type) || ('B' == *type) ||
		('A' == *type) || ('D' == *type) || ('C' == *type))
        { strcpy(shars[i].address,address);
          strcpy(shars[i].entry,entry);
          shars[i].type = *type;
          i++;
          if (i==MAX)
          { puts("to many shared lib entries");
            exit(1);
          }
        }
      }
    
  } while (1);
  fclose(F);
  numshars = i;
  
  module[0] = 0;
  
  gets(buf);
  if (feof(stdin))
    error("bad libc");;
    
  gets(buf);
  if (feof(stdin))
    error("bad libc");
  if (!strncmp(buf,"../libc.a:",10))
    DoLibc = 2;
    
  F = NULL;  
  module[0] = 0;
  do
  {
    if (DoLibc == 2)
    { DoLibc--;
      strcpy(buf,"environ.o:");
    }  
    else  
    if (DoLibc == 1)
    { DoLibc--;
      strcpy(buf,"00000000 D _environ");
    }  
    else
      gets(buf);
    if (feof(stdin))
      break;
    if (!buf[0])  
    { module[0] = 0;
      if (F)
      {
#if 0
        if (symbol != NULL)
          fprintf(F, ".stabs \"_%s\",0,0,0,0\n", symbol);
#endif
        fclose(F);
      }
      F = NULL;  
    }
    else
      if (!module[0])
      { strcpy(module,buf);
        i = strlen(buf)-1;
        module[i] = 0;
        if (('o' == module[i-1]) && ('.' == module[i-2]))
          module[i-1] = 's';
        else
        { printf("warning: non .o module %s\n", module );  
          continue;
        }
        F = NULL;
      }
      else
      {
        sscanf(buf,"%s %s %s", address, type, entry );
        if (strlen(address)<8)
          continue;
#if 1
        if (('T' == *type) || ('B' == *type) || ('D' == *type) || ('C' == *type) || ('I' == *type))
#else
        if (('T' == *type) || ('B' == *type) || ('D' == *type) || ('C' == *type))
#endif
        {
          for (j=0; j<numshars; j++)
	    if (jump) {
		if (*type == 'T' || *type == 'I') {
		  strcpy (jumpbuf, entry);
		  strcat (jumpbuf, "__jump");
	    	  if (((shars[j].type == 'T' && *type == 'I') ||
			(shars[j].type == *type)) && 
			(!strcmp(shars[j].entry,jumpbuf)))
                        break;  
		}
		else {
	    	  if (((shars[j].type == 'B' && *type == 'C') ||
			(shars[j].type == 'D' && *type == 'C') ||
			(shars[j].type == *type)) && 
			(!strcmp(shars[j].entry,entry)))
                        break;  
		}
	    }
	    else if (((shars[j].type == 'B' && *type == 'C') ||
#if 0
		(shars[j].type == 'D' && *type == 'C') ||
		(shars[j].type == 'T' && *type == 'B') ||
		(shars[j].type == 'T' && *type == 'C') ||
		(shars[j].type == 'T' && *type == 'D') ||
		(shars[j].type == 'T' && *type == 'I') ||
#else
		(shars[j].type == 'D' && *type == 'C') ||
		(shars[j].type == 'T' && *type == 'C') ||
		(shars[j].type == 'A' && *type == 'T') ||
		(shars[j].type == 'A' && *type == 'I') ||
		(shars[j].type == 'T' && *type == 'I') ||
#endif
                (shars[j].type == *type)) && 
                (!strcmp(shars[j].entry,entry)))
              break;  

          if (j<numshars)    
          {
            if (!F) {
     	      if (F = fopen(module, "w")) {
		if (symbol1 != NULL) {
#if 0
		  fprintf(F, "\t.align\t2\n");
#endif
		  fprintf(F, "\t.long\t_%s\n", symbol1);
		}
		if (symbol2 != NULL) {
#if 0
		  fprintf(F, "\t.align\t2\n");
#endif
		  fprintf(F, "\t.long\t_%s\n", symbol2);
		}
              }
	      else {
		printf("error: can not open %s\n", module );
                exit(1);
	      }
	    }
            fprintf(F, ".globl %s\n%s = 0x%s\n", entry,entry,shars[j].address);
          }
          else
            printf("warning: no address found for entry %s\n", entry);
        }
      }
    
  } while (1);
  if (F)
  {
#if 0
    if (symbol != NULL)
      fprintf(F, ".stabs \"_%s\",0,0,0,0\n", symbol);
#endif
    fclose(F);
  }
}
